//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "rcnt.h"

#include "hardware.h"
#include "bios.h"
#include "irq.h"
#include "timing.h"

#include "defs.h"

#include <stdio.h>
/******************************************************************************/
register unsigned long *psxregs		__asm__("esi");
/******************************************************************************/
static struct RCounter
{
	unsigned long Target;
	unsigned long Mode;
	unsigned long Step;
	unsigned long Start;
	void (*fHandler)();
}
RCnt[4];
/******************************************************************************/
const unsigned long RCntIrqType[4] = { 0xff, IP_ROOT1, IP_ROOT2, IP_ROOT3 };
/******************************************************************************/
const unsigned long RCntIrqMask[4] = { 0x10, 0x20, 0x40, 0x01 };
/******************************************************************************/

#define IRQFUNCROOT( i )													\
IrqFuncResult IrqFuncRoot ## i(void)										\
{																			\
	RCnt[i].fHandler();														\
	return (IrqFuncResult) { { RCntIrqMask[i] , RCnt[i].Step } };			\
}

IRQFUNCROOT(0)
IRQFUNCROOT(1)
IRQFUNCROOT(2)
IRQFUNCROOT(3)
/******************************************************************************/
IrqFuncResult (* const RCntIrqFunc[4])() = { IrqFuncRoot0, IrqFuncRoot1, IrqFuncRoot2, IrqFuncRoot3 };
/******************************************************************************/
void cpuRCntHandlerDef(void){}
/******************************************************************************/
void cpuRCntHandlerSet( long place, void (*func)() )
{
	if( ( place < 0 ) || ( place > 3 ) ) return;
	RCnt[ place ].fHandler = func;
}
/*** hle functions ************************************************************/
/* SetRCnt *//* complete */
long	hleSetRCnt(unsigned long spec, unsigned short target, long mode)
{
	printf("[ hle ] SetRCnt( %lx , %x , %lx )\n", spec, target, mode);//log
	if( (spec &= 0x0000ffff) < 3 )
	{
		RCnt[ spec ].Target = target;
		RCnt[ spec ].Mode = mode;
		RCnt[ spec ].Step = cpuIrqWaitSet( target, RCntIrqFunc[ spec ], RCntIrqType[ spec ] );
        RCnt[ spec ].Start = cpuIrqPSXClockGet();
		return 1;
	}
	return 0;
}
/* StartRCnt *//* complete */
long	hleStartRCnt(unsigned long spec)
{
	printf("[ hle ] StartRCnt( %lx )\n", spec);//log
	cpuIrqMaskEnable( RCntIrqMask[ spec&= 0x0000ffff ] );
	return ( spec < 3 );
}
/*** psx functions ************************************************************/
/* b0_02 *//* complete */
static void psxStartRCnt(void)
{
	psxregs[ REG_V0 ] = hleStartRCnt( psxregs[ REG_A0 ] );
}
/* b0_04 *//* complete */
static void psxSetRCnt(void)
{
	psxregs[ REG_V0 ] = hleSetRCnt( psxregs[ REG_A0 ] ,
		psxregs[ REG_A1 ] , psxregs[ REG_A2 ] );
}
/*** hwfunctions **************************************************************/
/* Value */
static void WriteRoot1ValueWord(long) __attribute__((regparm(1)));
static void WriteRoot1ValueWord(long data)
{
	printf("[ TIMIN ]( root1 )Warning: Write Word to Value Register\n");
}
static long ReadRoot1ValueWord(void)
{
	printf("[ TIMIN ]( root1 )Warning: Read Word from Value Register\n");
	return ( cpuIrqPSXClockGet() - RCnt[1].Start );//testing 
}
/* Mode */
static void WriteRoot1ModeWord(long) __attribute__((regparm(1)));
static void WriteRoot1ModeWord(long data)
{
	printf("[ TIMIN ]( root1 )Write Word to Mode Register\n");///???
//  long __Target;
//  Root1Mode = data;
//  if( data & 0x00000008 ) __Target = 0x0000ffff;
//  else __Target = Root1Target;
//need add something
// hclocks to count = target
// curcount
}
static long ReadRoot1ModeWord(void)
{
	printf("[ TIMIN ]( root1 )Read Word from Mode Register\n");///???s
	return 0;//need correction
//	return RCnt[1].Mode;
}
/* Target */
static void WriteRoot1TargetWord(long) __attribute__((regparm(1)));
static void WriteRoot1TargetWord(long data)
{
	RCnt[ 1 ].Target = data & 0x0000ffff;
}
static long ReadRoot1TargetWord(void)
{
	return RCnt[1].Target;
}
/*** plugin functions *********************************************************/
/* Start */
long	rcntStart()
{
	RCnt[ 3 ].Step = cpuIrqWaitSet( 1, RCntIrqFunc[ 3 ], RCntIrqType[ 3 ] );
	return 0;
}
/* Open */
long	rcntOpen()
{
	long i;
	for( i = 0 ; i < 4 ; i++ ) RCnt[i].fHandler = cpuRCntHandlerDef;
	cpuHookBIOSB0( psxSetRCnt , 0x02 );
	cpuHookBIOSB0( psxStartRCnt , 0x04 );
	cpuHookPortWord( WriteRoot1ValueWord, ReadRoot1ValueWord, 0x00001110 );
	return 0;
}
