#include "emulator.h"
#include "storage.h"
#include "plugin.h"
#include "funcs.h"

#include "cpudefs.h"

#include <stdio.h>
#include <stdlib.h>
/******************************************************************************/
static RbPSe_Emulator *Emulator;
static RbPSe_Plugin Plugin;
static RbPSe_Storage Storage;
/******************************************************************************/
register unsigned long *psxregs		__asm__("esi");
/******************************************************************************/
static HWHookType HWHookWord;
static DMASetHookType DMASetHook;
static cpuRCntHandlerSetType cpuRCntHandlerSet;
/******************************************************************************/

static long (*___GPUinit)();
static long (*___GPUclose)();
static long (*___GPUshutdown)();
static long (*___GPUreadData)();
static long (*___GPUreadStatus)();
static void (*___GPUupdateLace)();
#if   defined ( Windows )
static long (*___GPUopen)(void*) __attribute__((stdcall));
static void (*___GPUwriteData)(long) __attribute__((stdcall));
static void (*___GPUwriteStatus)(long) __attribute__((stdcall));
static void (*___GPUwriteDataMem)(void*,int) __attribute__((stdcall));
//static void (*___GPUreadDataMem)(void*,int) __attribute__((stdcall));
static long (*___GPUdmaChain)(void*,long) __attribute__((stdcall));
#elif defined ( Linux )
#elif defined ( BeOS )
static long (*___GPUopen)();//?
#endif

/******************************************************************************/

static long num = 0;

static unsigned long *DMAData2;

static long DMAFunction2(long) __attribute__((regparm(1)));
static long DMAFunction2(long dma_control)
{
//	printf("^^dma_control^^2^^=%lx^^\n", dma_control);
	if( dma_control & 0x00000001 )
	{
//		char buffer[32];
//		FILE *fout;
		if( dma_control & 0x00000400 )
		{
			printf("(%3li)( dma )( 2 ) Chain [ %lx ][ 0 ][ %lx ]\n", num++, DMAData2[0], DMAData2[2] );
			___GPUdmaChain(Emulator->Memory, DMAData2[0] & 0x001fffff);
		}
		else
		{
			printf("(%3li)( dma )( 2 ) Mem [ %lx ][ %lx ][ %lx ]\n", num++, DMAData2[0], DMAData2[1], DMAData2[2] );
			___GPUwriteDataMem(Emulator->Memory + (DMAData2[0] & 0x001fffff),
				(DMAData2[1] >> 16) * (DMAData2[1] & 0x0000ffff));
		}
//		sprintf( buffer, "gpu_log.%3li", num++ );
//		fout = fopen( buffer, "wb+" );
//		fwrite( Emulator->Memory, 1, 0x00200000, fout );
//		fclose( fout );
	}
	else
	{
		printf("[ GPU ]Error: Not defined dma function\n");
	}
	return 1;
}

/******************************************************************************/

static unsigned long *DMAData6;

static long DMAFunction6(long) __attribute__((regparm(1)));
static long DMAFunction6(long dma_control)
{
    char *base = Emulator -> Memory;
	long addr = DMAData6[0] & 0x001fffff;
	long block = DMAData6[1];
	printf("( dma )( 6 ) Mem [ %lx ][ %lx ][ %lx ]\n", DMAData6[0], DMAData6[1], DMAData6[2] );
	do
	{
		addr -= 4;
		*((long*)( base + addr + 4 )) = addr;
	} while( --block );
	*((long*)( base + addr + 4 )) = 0x00ffffff;
	return 1;
}

/******************************************************************************/

static long Read1814(void)
{
	long ltmp = ___GPUreadStatus();
//	printf("( gpu )( %3li )( 1814 Read = [ %lx ] )\n", num, ltmp );
	return ltmp;
}

static long Read1810(void)
{
	long ltmp = ___GPUreadData();
//	printf("( gpu )( %3li )( 1810 Read = [ %lx ] )\n", num, ltmp );
	return ltmp;
}

static void Write1814(long) __attribute__((regparm(1)));
static void Write1814(long data)
{
//	printf("( gpu )( %3li )( 1814 Write = [ %lx ] )\n", num, data );
	___GPUwriteStatus(data);
}

static void Write1810(long) __attribute__((regparm(1)));
static void Write1810(long data)
{
//	printf("( gpu )( %3li )( 1810 Write = [ %lx ] )\n", num, data );
	___GPUwriteData(data);
}

/******************************************************************************/
void psxResetGraph(void)
{
	printf("[ psx ] ResetGraph( %li )\n", psxregs[ REG_A0 ] );
	fflush(0);
}
void psxSetGraphDebug(void)
{
	printf("[ psx ] SetGraphDebug( %li )\n", psxregs[ REG_A0 ] );
	fflush(0);
}
/******************************************************************************/

static long Start()
{
	return 0;
}

static long Open()
{
	char *buffer;
	void *hlib;
	buffer = malloc(256);
	Emulator -> Interface -> GetConfigStr( "plugin_gpu_psemu.cfg" ,
		"psemu" , "plugin" , "gpu" , buffer);
	hlib = Emulator -> Interface -> PluginLoad( buffer );
	if(!hlib)
	{
		printf("Can't load gpu psemu library - %s -\n",buffer);//?
		return -2;
	}
	___GPUinit			= Emulator -> Interface -> PluginData( hlib , "GPUinit" );
	___GPUopen			= Emulator -> Interface -> PluginData( hlib , "GPUopen" );
	___GPUclose			= Emulator -> Interface -> PluginData( hlib , "GPUclose" );
	___GPUshutdown		= Emulator -> Interface -> PluginData( hlib , "GPUshutdown" );
	___GPUwriteData		= Emulator -> Interface -> PluginData( hlib , "GPUwriteData" );
	___GPUreadData		= Emulator -> Interface -> PluginData( hlib , "GPUreadData" );
	___GPUwriteStatus	= Emulator -> Interface -> PluginData( hlib , "GPUwriteStatus" );
	___GPUreadStatus	= Emulator -> Interface -> PluginData( hlib , "GPUreadStatus" );
	___GPUupdateLace	= Emulator -> Interface -> PluginData( hlib , "GPUupdateLace" );
	___GPUwriteDataMem	= Emulator -> Interface -> PluginData( hlib , "GPUwriteDataMem" );
	___GPUdmaChain		= Emulator -> Interface -> PluginData( hlib , "GPUdmaChain" );
//
	if( !___GPUinit || !___GPUopen || !___GPUclose || !___GPUshutdown ||
		!___GPUwriteData || !___GPUreadData || !___GPUwriteStatus || !___GPUreadStatus ||
		!___GPUupdateLace || !___GPUwriteDataMem || !___GPUdmaChain )
	{
		printf("[  GPU  ]Error: incorrect or oldstyle PSEmuPro plugin: %s\n",buffer);
		return -1;
	}
//
	___GPUinit();
#if   defined( Windows )
	___GPUopen( Emulator -> Display );
#elif defined( Linux )
#elif defined( BeOS )
#endif
//
	if(STORAGE_GET_FUNC(HWHookWord,HWHookType,"cpuHookPortWord")) return -1;
	if(STORAGE_GET_FUNC(DMASetHook,DMASetHookType,"___DMASetHook")) return -1;
	HWHookWord( Write1810 , Read1810 , 0x00001810 );
	HWHookWord( Write1814 , Read1814 , 0x00001814 );
//
	DMAData2 = DMASetHook( DMAFunction2 , 2 );
	DMAData6 = DMASetHook( DMAFunction6 , 6 );
//
	if(STORAGE_GET_FUNC(cpuRCntHandlerSet,cpuRCntHandlerSetType,"cpuRCntHandlerSet")) return -1;
	cpuRCntHandlerSet( 3, ___GPUupdateLace );
//
	return 0;
}
/* Init */
static long Init()
{
//	STORAGE_SET("psxResetGraph",	psxResetGraph,		0);
//	STORAGE_SET("psxSetGraphDebug",	psxSetGraphDebug,	0);
	return 0;
}
/* Plugin */
RbPSe_Plugin *RbPSePluginLoad(RbPSe_Emulator* emulator)
{
	Emulator = emulator;
	Plugin.Init = Init;
	Plugin.Open = Open;
	Plugin.Start = Start;
	return &Plugin;
}
