//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "memory.h"

#include "hardware.h"
#include "structs.h"
#include <stdio.h>
#include <string.h>

extern RbPSe_Emulator *Emulator;
/******************************************************************************/
static char rammemory[0x00200000];
/******************************************************************************/
//register char *psxmemory __asm__("edi");// Can be replaced
/******************************************************************************/

void cpuClearData(long dst, long count)
{
	memset( rammemory + ( dst & 0x001fffff ) , 0 , count );
}

void cpuWriteData(long dst, void *src, long count)
{
	printf("MemoryWriteData(%lx,%lx,%lx)\n",dst,(long)src,count);
	memcpy( rammemory + ( dst & 0x001fffff ) , src , count );
}

/******************************************************************************/

long cpuReadDataWord(long addr)
{
	if( addr & 0x00800000 )
	{
		return cpuReadPortWord(addr);
	}
	else
	{
		return *((long*)( rammemory + ( addr & 0x001fffff )));
	}
}

unsigned short cpuReadDataHalfU(long addr)
{
	if( addr & 0x00800000 )
	{
		return cpuReadPortHalf(addr);
	}
	else
	{
		return *((unsigned short*)( rammemory + ( addr & 0x001fffff )));
	}
}

short cpuReadDataHalf(long addr)
{
	if( addr & 0x00800000 )
	{
		return cpuReadPortHalf(addr);
	}
	else
	{
		return *((short*)( rammemory + ( addr & 0x001fffff )));
	}
}

unsigned char cpuReadDataByteU(long addr)
{
	if( addr & 0x00800000 )
	{
		return cpuReadPortByte(addr);
	}
	else
	{
		return *((unsigned char*)( rammemory + ( addr & 0x001fffff )));
	}
}

char cpuReadDataByte(long addr)
{
	if( addr & 0x00800000 )
	{
		return cpuReadPortByte(addr);
	}
	else
	{
		return *((char*)( rammemory + ( addr & 0x001fffff )));
	}
}

void cpuWriteDataWord(long data, long addr)
{
	if( addr & 0x00800000 )
	{
		cpuWritePortWord(data,addr);
	}
	else
	{
		if( ( addr & 0x001fffff ) == 0x000a4a78 )
		{
			printf("( mem )( Write Word [ %lx ] to [ %lx ] )\n", data, addr );
		}
		if( ( addr & 0x001fffff ) == 0x00112cdc )
		{
			printf("( mem )( Write Word [ %lx ] to [ %lx ] )\n", data, addr );
		}
		*((long*)( rammemory + ( addr & 0x001fffff ))) = data;
	}
}

void cpuWriteDataHalf(short data, long addr)
{
	if( addr & 0x00800000 )
	{
		cpuWritePortHalf(data,addr);
	}
	else
	{
		if( ( addr & 0x001fffff ) == 0x0008acfc )
		{
			printf("( mem )( Write Half [ %x ] to [ %lx ] )\n", data, addr );
		}
		*((short*)( rammemory + ( addr & 0x001fffff ))) = data;
	}
}

void cpuWriteDataByte(char data, long addr)
{
	if( addr & 0x00800000 )
	{
		cpuWritePortByte(data,addr);
	}
	else
	{
		if( ( addr & 0x001fffff ) == 0x0008acfc )
		{
			printf("( mem )( Write Byte [ %x ] to [ %lx ] )\n", data, addr );
		}
		*((char*)( rammemory + ( addr & 0x001fffff ))) = data;
	}
}

static const unsigned long local1[4] = { 0x00000000, 0xff000000, 0xffff0000, 0xffffff00 };
static const unsigned long local2[4] = { 0x00000000, 0x00000008, 0x00000010, 0x00000018 };

void	cpuReadDataWordRight( long addr, unsigned long *reg )
{
	long shift = addr & 3;
	unsigned long *mem = (long*)( rammemory + ( addr & 0x001ffffc ));
	*reg = ( *reg & local1[ shift ] ) | ( *mem >> local2[ shift ] );
}

static const unsigned long local3[4] = { 0x00ffffff, 0x0000ffff, 0x000000ff, 0x00000000 };
static const unsigned long local4[4] = { 0x00000018, 0x00000010, 0x00000008, 0x00000000 };

void    cpuReadDataWordLeft( long addr, unsigned long *reg )
{
	long shift = addr & 3;
	unsigned long *mem = (long*)( rammemory + ( addr & 0x001ffffc ));
	*reg = ( *reg & local3[ shift ] ) | ( *mem << local4[ shift ] );
}

static const unsigned long local5[4] = { 0x00000000, 0x000000ff, 0x0000ffff, 0x00ffffff };
static const unsigned long local6[4] = { 0x00000000, 0x00000008, 0x00000010, 0x00000018 };

void	cpuWriteDataWordRight( long addr, unsigned long *reg )
{
	long shift = addr & 3;
	unsigned long *mem = (long*)( rammemory + ( addr & 0x001ffffc ));
	*mem = ( *mem & local5[ shift ] ) | ( *reg << local6[ shift ] );
}

static const unsigned long local7[4] = { 0xffffff00, 0xffff0000, 0xff000000, 0x00000000 };
static const unsigned long local8[4] = { 0x00000018, 0x00000010, 0x00000008, 0x00000000 };

void	cpuWriteDataWordLeft( long addr, unsigned long *reg )
{
	long shift = addr & 3;
	unsigned long *mem = (long*)( rammemory + ( addr & 0x001ffffc ));
	*mem = ( *mem & local7[ shift ] ) | ( *reg >> local8[ shift ] );
}

/******************************************************************************/

long memoryOpen()
{
	long i;
	for( i = 0 ; i < 0x00200000 ; i++ ){ rammemory[i] = 0; }
	for( i = 0 ; i < 0x20 ; i++ ){ *((long*)(Emulator -> Storage) + i) = 0; }
	Emulator -> Memory = rammemory;
	return 0;
}

