#ifndef _EMULATOR_H_
#define _EMULATOR_H_

#include "structs.h"

enum
{
	SOURCE_TYPE_NONE = 0,
	SOURCE_TYPE_CD = 1,
	SOURCE_TYPE_ISO = 2,
	SOURCE_TYPE_FILE = 3,
};

#define SOURCE_TYPE_STRING(type) \
	type == SOURCE_TYPE_NONE ? "TYPE_NONE" : \
	type == SOURCE_TYPE_CD ? "TYPE_CD" : \
	type == SOURCE_TYPE_ISO ? "TYPE_ISO" : \
	type == SOURCE_TYPE_FILE ? "TYPE_FILE" : "TYPE_UNKNOWN";

enum
{
	EMULATOR_STATE_ERROR = 0,
	EMULATOR_STATE_INIT = 1,
	EMULATOR_STATE_OPEN = 2,
	EMULATOR_STATE_START = 3,
	EMULATOR_STATE_STOP = 4,
	EMULATOR_STATE_CLOSE = 5,
	EMULATOR_STATE_QUIT = 6
};

#endif
