#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include "defs.h"

typedef struct
{
	char *name;
	void (*func)();
	long place;
}
RbPSe_Storage;

typedef struct
{
	long (*Init)();
	long (*Open)();
	long (*Start)();
	long (*Stop)();
	long (*Close)();
	long (*Quit)();
	long (*Save)();
	long (*Load)();
}
RbPSe_Plugin;

typedef struct
{
//
	long (*Init)(int,char**);
	long (*Exec)();
	void (*Quit)();
	void (*Fatal)();
//
	void *(*PluginLoad)(char*);
	void *(*PluginData)(void*,char*);
	void (*PluginFree)(void*);
//
	char *(*GetConfigStr)(char*,char*,char*,char*,char*);
	long (*GetConfigLong)(char*,char*,char*,long);
//
	void *(*CreateTh)(void*,void*);
	void (*ExitTh)(long);
//
	void (*InitCritical)(void**);
	void (*EnterCritical)(void**);
	void (*LeaveCritical)(void**);
	void (*QuitCritical)(void**);
//
	long long (*GetStepClock)(long);
//
	long (*MapOpen)(char*,long);
//	char (*GetDirSymbol)();
}
RbPSe_Interface;

#define MAX_PLUGINS 32

typedef struct
{
//Source Control
	long SourceType;
	char *SourceName;
	char *SourceDevice;
//Globals
	void *Storage;
	void *Storage2;
	void *Memory;
    void *Display;//possibly need to be replaced by interface function
//
	long (*StorageSet)(RbPSe_Storage*);
	long (*StorageGet)(RbPSe_Storage*);
//Interface
	RbPSe_Interface *Interface;
//Plugins
	long PluginsCount;
	void *hPlugins[MAX_PLUGINS];
	RbPSe_Plugin *Plugins[MAX_PLUGINS];
}
RbPSe_Emulator;

#endif
