//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "bios_string.h"

#include "hle_string.h"

#include "defs.h"

#include <stdio.h>
/******************************************************************************/
register unsigned long *psxregs		__asm__("esi");
register unsigned char *psxmemory	__asm__("edi");
/******************************************************************************/
void psxstrncmp(void)
{
	printf("[ psx ] strncmp( %s , %s , %lx )\n", psxmemory + ( psxregs[ REG_A0 ] & 0x001fffff ) ,
		psxmemory + ( psxregs[ REG_A1 ] & 0x001fffff ) , psxregs[ REG_A2 ] );
	psxregs[ REG_V0 ] = hlestrncmp( psxmemory + ( psxregs[ REG_A0 ] & 0x001fffff ) ,
		psxmemory + ( psxregs[ REG_A1 ] & 0x001fffff ) , psxregs[ REG_A2 ] );
}
/******************************************************************************/
void psxstrlen(void)
{
	printf("[ psx ] strlen( %s )\n", psxmemory + ( psxregs[ REG_A0 ] & 0x001fffff ) );
	psxregs[ REG_V0 ] = hlestrlen( psxmemory + ( psxregs[ REG_A0 ] & 0x001fffff ) );
}
/******************************************************************************/
void psxbzero(void)
{
	printf("[ psx ] bzero( %lx , %lx )\n" , psxregs[ REG_A0 ] , psxregs[ REG_A1 ] );
	hlebzero( psxmemory + ( psxregs[ REG_A0 ] & 0x001fffff ) , psxregs[ REG_A1 ] );
}
/******************************************************************************/
void psxmemcpy(void)
{
	printf("[ psx ] memcpy( %lx , %lx , %lx )\n" , psxregs[ REG_A0 ] ,
		psxregs[ REG_A1 ] , psxregs[ REG_A2 ] );
	hlememcpy( psxmemory + ( psxregs[ REG_A0 ] & 0x001fffff ) ,
		psxmemory + ( psxregs[ REG_A1 ] & 0x001fffff ) , psxregs[ REG_A2 ] );
	psxregs[ REG_V0 ] = psxregs[ REG_A0 ];
}
/******************************************************************************/
