#include "event.h"

#include <stdio.h>

/******************************************************************************/
register unsigned long *psxregs     __asm__("esi");
register unsigned char *psxmemory   __asm__("edi");
/*** event functions **********************************************************/
/* get_free_EvCB_slot */
static long get_free_EvCB_slot()
{
	struct EvCB *curEvCB, *maxEvCB;
	curEvCB = (struct EvCB*)SysToT[4].head;
	maxEvCB = (struct EvCB*)( (char*)curEvCB + SysToT[4].size );
	do
	{
		if( curEvCB -> status == EvStUNUSED ) return ( curEvCB - (struct EvCB*)SysToT[4].head );
		curEvCB++;
	}
	while( curEvCB < maxEvCB );
	return -1;
}
/* Deliver Event */
void hleDeliverEvent(unsigned long ev1, long ev2)//b0_07
{
	struct EvCB *curEvCB, *maxEvCB;
	printf("[ hle ] DeliverEvent( %lx , %lx )\n", ev1, ev2 );
	curEvCB = (struct EvCB*)SysToT[4].head;
	maxEvCB = (struct EvCB*)( (char*)curEvCB + SysToT[4].size );
	do
	{
		if((curEvCB->status == EvStACTIVE)&&(curEvCB->desc == ev1)&&(curEvCB->spec == ev2))
		{
			if(curEvCB -> mode == EvMdNOINTR) curEvCB -> status = EvStALREADY;
			else (curEvCB -> FHandler)();
		}
		curEvCB++;
	}
	while( curEvCB < maxEvCB );
}
/* Open Event */
long hleOpenEvent(unsigned long desc, long spec, long mode, long (*func)())
{
	long slot;
	struct EvCB *curEvCB;
	printf("[ hle ] OpenEvent( %lx , %lx , %lx , %lx )\n", desc, spec, mode, (long)func );//log
	slot = get_free_EvCB_slot();
	if( -1 == slot ) return -1;
	curEvCB = ((struct EvCB*)SysToT[4].head) + slot;
	curEvCB -> desc = desc;
	curEvCB -> status = EvStWAIT;
	curEvCB -> spec = spec;
	curEvCB -> mode = mode;
	curEvCB -> FHandler = func;
	return DescEV | slot;
}
/* Enable Event */
long hleEnableEvent(long event)
{
	struct EvCB *curEvCB;
	printf("[ hle ] EnableEvent( %lx )\n", event );//log
	curEvCB = ((struct EvCB*)SysToT[4].head) + ( event & 0x0000ffff );
	if( curEvCB -> status != EvStUNUSED ) curEvCB -> status = EvStACTIVE;
	return 1;
}
