#include "emulator.h"
#include "storage.h"
#include "plugin.h"
#include "funcs.h"

#include <stdio.h>
#include <stdlib.h>
/******************************************************************************/
static RbPSe_Emulator *Emulator;
static RbPSe_Plugin Plugin;
static RbPSe_Storage Storage;
/******************************************************************************/
static HWHookType HWHookHalf;
static DMASetHookType DMASetHook;
/******************************************************************************/

static long (*___SPUinit)();
static long (*___SPUclose)();
static long (*___SPUshutdown)();
#if   defined ( Windows )
static long (*___SPUopen)(void*) __attribute__((stdcall));
static void (*___SPUwriteRegister)(long,short) __attribute__((stdcall));
static short (*___SPUreadRegister)(long) __attribute__((stdcall));
static void (*___SPUwriteDMAMem)(void*,int) __attribute__((stdcall));
static void (*___SPUreadDMAMem)(void*,int) __attribute__((stdcall));
#elif defined ( BEOS )
static long (*___SPUopen)();//?
#endif
/******************************************************************************/

static void WriteSPURegister(short,long) __attribute__((regparm(2)));
static short ReadSPURegister(long) __attribute__((regparm(1)));

static long DMAFunction4(long) __attribute__((regparm(1)));

/******************************************************************************/

static unsigned long *DMAData4;

static long DMAFunction4(long dma_control)
{
//	printf("^^dma_control^^4^^=%lx^^\n", dma_control);
	if( dma_control & 0x00000001 )
	{
		printf("( dma )( 4 ) Mem [ %lx ][ %lx ]\n", Emulator->Memory + (DMAData4[0] & 0x001fffff),
			(DMAData4[1] >> 16) * (DMAData4[1] & 0x0000ffff) * 2);
		___SPUwriteDMAMem(Emulator->Memory + (DMAData4[0] & 0x001fffff),
			(DMAData4[1] >> 16) * (DMAData4[1] & 0x0000ffff) * 2);
	}
	else
	{
		printf("[ SPU ] Error: Not defined dma function\n");
	}
	return 1;
}

/******************************************************************************/

static short ReadSPURegister(long addr)
{
	return ___SPUreadRegister(addr);
}

static void WriteSPURegister(short data, long addr)
{
	___SPUwriteRegister(addr, data);
}

/******************************************************************************/

static long Start()
{
	return 0;
}

static long Open()
{
	char *buffer;
	void *hlib;
	long i;
	buffer = malloc(256);
	Emulator -> Interface -> GetConfigStr( "plugin_spu_psemu.cfg" ,
		"psemu" , "plugin" , "spu" , buffer);
	hlib = Emulator -> Interface -> PluginLoad( buffer );
	if(!hlib)
	{
		printf("Can't load spu psemu library - %s -\n",buffer);//?
		return -2;
	}
	___SPUinit			= Emulator -> Interface -> PluginData( hlib , "SPUinit" );
	___SPUopen			= Emulator -> Interface -> PluginData( hlib , "SPUopen" );
	___SPUclose			= Emulator -> Interface -> PluginData( hlib , "SPUclose" );
	___SPUshutdown		= Emulator -> Interface -> PluginData( hlib , "SPUshutdown" );
	___SPUwriteRegister	= Emulator -> Interface -> PluginData( hlib , "SPUwriteRegister" );
	___SPUreadRegister	= Emulator -> Interface -> PluginData( hlib , "SPUreadRegister" );
//	___SPUwriteDMA		= Emulator -> Interface -> PluginData( hlib , "SPUwriteDMA" );
//	___SPUreadDMA		= Emulator -> Interface -> PluginData( hlib , "SPUreadDMA" );
	___SPUwriteDMAMem	= Emulator -> Interface -> PluginData( hlib , "SPUwriteDMAMem" );
	___SPUreadDMAMem	= Emulator -> Interface -> PluginData( hlib , "SPUreadDMAMem" );
//	___SPUregisterCallback	= Emulator -> Interface -> PluginData( hlib , "SPUregisterCallback" );
//
	if( !___SPUinit || !___SPUopen || !___SPUclose || !___SPUshutdown ||
		!___SPUwriteRegister || !___SPUreadRegister || !___SPUwriteDMAMem ||
		!___SPUreadDMAMem )
	{
		printf("[  SPU  ]Error: incorrect or oldstyle PSEmuPro plugin: %s\n",buffer);
		return -1;
	}
//
	___SPUinit();
	___SPUopen( Emulator -> Display );
//
	if(STORAGE_GET_FUNC(HWHookHalf,HWHookType,"cpuHookPortHalf")) return -1;
	if(STORAGE_GET_FUNC(DMASetHook,DMASetHookType,"___DMASetHook")) return -1;
	for( i = 0x00001c00 ; i < 0x00001e00 ; i++ ) HWHookHalf( WriteSPURegister , ReadSPURegister , i );
//
	DMAData4 = DMASetHook( DMAFunction4 , 4 );
//
	return 0;
}

static long Init()
{
	return 0;
}

RbPSe_Plugin *RbPSePluginLoad(RbPSe_Emulator* emulator)
{
	Emulator = emulator;
	Plugin.Init = Init;
	Plugin.Open = Open;
	Plugin.Start = Start;
	return &Plugin;
}
