//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "bios_stdio.h"
#include "bios_string.h"

#include "emulator.h"
#include "storage.h"
#include "funcs.h"
/******************************************************************************/
static RbPSe_Emulator *Emulator;
static RbPSe_Plugin Plugin;
static RbPSe_Storage Storage;
/******************************************************************************/
static cpuHookBIOSType cpuHookBIOSA0;
/******************************************************************************/
static long Close()
{
	return 0;
}

static long Stop()
{
	return 0;
}

static long Start()
{
	return 0;
}

static long Open()
{
	if(STORAGE_GET_FUNC(cpuHookBIOSA0,cpuHookBIOSType,"cpuHookBIOSA0")) return -1;
	cpuHookBIOSA0( psxstrncmp, 0x18 );
	cpuHookBIOSA0( psxstrlen, 0x1b );
	cpuHookBIOSA0( psxbzero, 0x28 );
	cpuHookBIOSA0( psxmemcpy, 0x2a );
	cpuHookBIOSA0( psxprintf, 0x3f );
	return 0;
}

static long Init()
{
	return 0;
}

RbPSe_Plugin *RbPSePluginLoad(RbPSe_Emulator* emulator)
{
	Emulator = emulator;
	Plugin.Init = Init;
	Plugin.Open = Open;
	Plugin.Start = Start;
	Plugin.Stop = Stop;
	Plugin.Close = Close;
	return &Plugin;
}
