//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "emulator.h"
#include "storage.h"

#include "hardware.h"
#include "memory.h"
#include "dyn.h"
#include "dma.h"
#include "bios.h"
#include "timing.h"
#include "rcnt.h"
#include "irq.h"
#include "hlecore.h"
#include "jmp.h"
#include "cop0.h"

#include "libetc_psx.h"

/******************************************************************************/
RbPSe_Emulator *Emulator;
static RbPSe_Plugin Plugin;
static RbPSe_Storage Storage;
/******************************************************************************/

static long Load()
{
	return 0;
}

static long Save()
{
	return 0;
}

static long Quit()
{
	return 0;
}

static long Close()
{
	return 0;
}

static long Stop()
{
	return 0;
}

static long Start()
{
	long retval;
	if(( retval = timingStart() )) return retval;
	if(( retval = rcntStart() )) return retval;
	return 0;
}

static long Open()
{
	long retval;
	if(( retval = hardwareOpen() )) return retval;
	if(( retval = memoryOpen() )) return retval;
	if(( retval = dynOpen() )) return retval;
	if(( retval = dmaOpen() )) return retval;
	if(( retval = biosOpen() )) return retval;
	if(( retval = timingOpen() )) return retval;
	if(( retval = hlecoreOpen() )) return retval;
	if(( retval = rcntOpen() )) return retval;
	if(( retval = irqOpen() )) return retval;
	if(( retval = jmpOpen() )) return retval;
	if(( retval = cop0Open() )) return retval;
	return 0;
}

static long Init()
{
//hw
	STORAGE_SET("cpuHookPortByte",	cpuHookPortByte,	0);
	STORAGE_SET("cpuHookPortHalf",	cpuHookPortHalf,	0);
	STORAGE_SET("cpuHookPortWord",	cpuHookPortWord,	0);
	STORAGE_SET("cpuWritePortByte",	cpuWritePortByte,	HWWRITE8);
	STORAGE_SET("cpuWritePortHalf",	cpuWritePortHalf,	HWWRITE16);
	STORAGE_SET("cpuWritePortWord",	cpuWritePortWord,	HWWRITE32);
	STORAGE_SET("cpuReadPortByte",	cpuReadPortByte,	HWREAD8);
	STORAGE_SET("cpuReadPortHalf",	cpuReadPortHalf,	HWREAD16);
	STORAGE_SET("cpuReadPortWord",	cpuReadPortWord,	HWREAD32);
//mem
	STORAGE_SET("cpuWriteDataByte",	cpuWriteDataByte,	MEMWRITE8);
	STORAGE_SET("cpuWriteDataHalf",	cpuWriteDataHalf,	MEMWRITE16);
	STORAGE_SET("cpuWriteDataWord",	cpuWriteDataWord,	MEMWRITE32);
	STORAGE_SET("cpuReadDataByte",	cpuReadDataByte,	MEMREAD8);
	STORAGE_SET("cpuReadDataByteU",	cpuReadDataByteU,	MEMREAD8U);
	STORAGE_SET("cpuReadDataHalf",	cpuReadDataHalf,	MEMREAD16);
	STORAGE_SET("cpuReadDataHalfU",	cpuReadDataHalfU,	MEMREAD16U);
	STORAGE_SET("cpuReadDataWord",	cpuReadDataWord,	MEMREAD32);
	STORAGE_SET("cpuWriteDataWordLeft",		cpuWriteDataWordLeft,	MEMWRITEL);
	STORAGE_SET("cpuWriteDataWordRight",	cpuWriteDataWordRight,	MEMWRITER);
	STORAGE_SET("cpuReadDataWordLeft",		cpuReadDataWordLeft,	MEMREADL);
	STORAGE_SET("cpuReadDataWordRight",		cpuReadDataWordRight,	MEMREADR);
	STORAGE_SET("cpuWriteData",		cpuWriteData, 0);
	STORAGE_SET("cpuClearData",		cpuClearData, 0);
//dyn
	STORAGE_SET("___CPUDecode", CPUDecode, CPUDECODE);
	STORAGE_SET("___CPUExec", cpuExec, 0);
//  STORAGE_SET("___CPUExecFunc", CPUExecFunc, 0);
	STORAGE_SET("___CPUWriteData", CPUWriteData, 0);
	STORAGE_SET("___CPUClearData", CPUClearData, 0);
	STORAGE_SET("cpuHookAddr",		cpuHookAddr,	0);
	STORAGE_SET("cpuHookOpCode",	cpuHookOpCode,	0);
//  STORAGE_SET("___CPUSetFuncEx",CPUSetFuncEx,0);
//dynopcode
	STORAGE_SET("cpuDynOpcodeDiv",	cpuDynOpcodeDiv,	DYNDIV);
	STORAGE_SET("cpuDynOpcodeDivU",	cpuDynOpcodeDivU,	DYNDIVU);
//dma
	STORAGE_SET("___DMASetHook",DMASetHook,0);
//bios
	STORAGE_SET("cpuHookBIOSA0",	cpuHookBIOSA0,	0);
	STORAGE_SET("cpuHookBIOSB0",	cpuHookBIOSB0,	0);
	STORAGE_SET("cpuHookBIOSC0",	cpuHookBIOSC0,	0);
	STORAGE_SET("cpuSystemCall",	cpuSystemCall,	SYSCALL);
//irq
	STORAGE_SET("cpuIrqRequest",	cpuIrqRequest,	0);
//	STORAGE_SET("hleResetEntryInt", hleResetEntryInt, 0);
//timing
	STORAGE_SET("cpuIrqWaitSet",	cpuIrqWaitSet,	0);
	STORAGE_SET("cpuIrqWaitFunc",	cpuIrqWaitFunc,	TIMING);
//rcnt
	STORAGE_SET("cpuRCntHandlerSet",	cpuRCntHandlerSet,	0);
//psx
	STORAGE_SET("psxVSync",             psxVSync,           	0);
	STORAGE_SET("psxResetCallback",		psxResetCallback,		0);
	STORAGE_SET("psxInterruptCallback",	psxInterruptCallback,	0);
	STORAGE_SET("psxDMACallback",		psxDMACallback,			0);
	STORAGE_SET("psxVSyncCallback",		psxVSyncCallback,		0);
	STORAGE_SET("psxVSyncCallbacks",	psxVSyncCallbacks,		0);
	STORAGE_SET("psxStopCallback",		psxStopCallback,		0);
	STORAGE_SET("psxRestartCallback",	psxRestartCallback,		0);
	return 0;
}

RbPSe_Plugin *RbPSePluginLoad(RbPSe_Emulator *emulator)
{
	Emulator = emulator;
	Plugin.Init = Init;
	Plugin.Open = Open;
	Plugin.Start = Start;
	Plugin.Stop = Stop;
	Plugin.Close = Close;
	Plugin.Quit = Quit;
	Plugin.Save = Save;
	Plugin.Load = Load;
	return &Plugin;
}
