//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "timing.h"

#include "irq.h"

#include "emulator.h"

#include <stdio.h>

/******************************************************************************/
register unsigned long *psxregs		__asm__("esi");
register unsigned char *psxmemory	__asm__("edi");
/******************************************************************************/

extern RbPSe_Emulator *Emulator;

static const unsigned long VSyncPerSecond[2] = { 60, 50 };
static const unsigned long HSyncPerVSync[2] = { 262, 312 };
static const unsigned long SysClockPerHSync[2] = { 2153, 2162 };
static const unsigned long SysClock8PerHSync[2] = { 269, 271 };

static unsigned long cpuIrqMode = IM_NTSC;

static struct
{
	long Clock[8];
	IrqFuncResult (*Func[8])();
}
IrqProcessing;

static const long MainTimerInc = 3;//config

static struct
{
	long Prev;
	long Step;
}
IrqPSXClock;

static const long CheckTime = 100;//config

static struct
{
	long long Prev;
	long long Have;//ostatoc
	long long Step;
	long TimeCurrent;
	long TimeCheck;
}
IrqPCClock;

/******************************************************************************/
long cpuIrqPSXClockGet(){ return IrqPSXClock.Prev; }
/******************************************************************************/
/* Irq Default Handler */
IrqFuncResult IrqDefFunc(){ return (IrqFuncResult){ { 0, 0x7fffffff } }; }
/******************************************************************************/
long cpuIrqWaitSet( long value, IrqFuncResult (*func)(), unsigned long place )
{
	switch( place )
    {
	case IP_ROOT3://value(1)
		printf("[ TIMING ] IRQ_PLACE = IP_ROOT3\nValue = %li\n", value );
        value *= HSyncPerVSync[ cpuIrqMode ];
		break;
	case IP_ROOT1:
		printf("[ TIMING ] IRQ_PLACE = IP_ROOT1\nValue = %li\n", value );
		break;
	case IP_ROOT2:
		printf("[ TIMING ] IRQ_PLACE = IP_ROOT2\nValue = %li\n", value );
		value /= SysClock8PerHSync[ cpuIrqMode ];
		break;
//	case IP_CDROM:
	default:
		printf("[ TIMING ] Error: Unsupported IRQ_PLACE type\n");
        return 0;
	}
	IrqProcessing.Clock[ place ] = IrqPSXClock.Prev + value;
	IrqProcessing.Func[ place ] = func;
	return value;
}
/******************************************************************************/
//extern void TimingFunction(void)	__asm__("TimingFunction");
//extern long TimingCounter			__asm__("TimingCounter");
//extern long TimingExec				__asm__("TimingExec");
//extern long long StepClock			__asm__("StepClock");
//extern long long PrevClock			__asm__("PrevClock");
//extern long long HaveClock			__asm__("HaveClock");
//extern long StepHSync				__asm__("StepHSync");
//extern long HWClockTimer			__asm__("HWClockTimer");
//extern long HWClockCounters[0x08]	__asm__("HWClockCounters");
//extern void *HWClockFunctions[0x08]	__asm__("HWClockFunctions");
/******************************************************************************/
//InterruptRequestType InterruptRequest __asm__("InterruptRequest");
/******************************************************************************/
static inline long long GetPCClock(void)
{
	long long tmp;
	__asm__ __volatile__ ( "rdtsc" : "=A" (tmp) );
	return tmp;
}
/******************************************************************************/
/* ROOT 1 FUNCTIONS */
/* Value */
/*static void WriteRoot1ValueWord(long) __attribute__((regparm(1)));
static void WriteRoot1ValueWord(long data)
{
	printf("[ TIMIN ]( root1 )Warning: Write Word to Value Register\n");
}
static long ReadRoot1ValueWord(void)
{
	printf("[ TIMIN ]( root1 )Warning: Write Word to Value Register\n");
	return 0;//need correction
}*/
/* Mode */
/*static void WriteRoot1ModeWord(long) __attribute__((regparm(1)));
static void WriteRoot1ModeWord(long data)
{
	printf("[ TIMIN ]( root1 )Warning: Write Word to Value Register\n");
//  long __Target;
//  Root1Mode = data;
//  if( data & 0x00000008 ) __Target = 0x0000ffff;
//  else __Target = Root1Target;
//need add something
// hclocks to count = target
// curcount
}
static long ReadRoot1ModeWord(void)
{
	printf("[ TIMIN ]( root1 )Warning: Write Word to Value Register\n");
	return RCnt[1].mode;
}*/
/* Target */
/******************************************************************************/
/*static long Root1Mode;
static long Root1Target;
static long Root1IRQEnable;*/
//static union word_part hle_root
/******************************************************************************/
/* STUFF!!! */
/* DO NOT DEL, VERY IMPORTANT */
/*static long long StepClock;
static long long PrevClock;
static long long HaveClock;
static long TimingCounter;
static long TimingExec;
static void TimingFunction(void)
{
	long long ll_tsc;
	long long ll_tmp;
	if( ++TimingCounter >= TimingExec )
	{
		ll_tsc = __rdtsc();
		if((ll_tmp = ll_tsc - PrevClock + HaveClock) >= StepClock)
		{
			HaveClock = ll_tmp - StepClock;
			PrevClock = ll_tsc;
		}
	}
}*/
/******************************************************************************/
/* NEW STUFF!!! */

void cpuIrqWaitFunc(void)
{
	if( ++IrqPCClock.TimeCurrent >= IrqPCClock.TimeCheck )
	{
		long long pc_clock = GetPCClock();
		IrqPCClock.TimeCurrent = 0;
		if( ( pc_clock - IrqPCClock.Prev + IrqPCClock.Have ) >= IrqPCClock.Step )
		{
			IrqPCClock.Have = pc_clock - IrqPCClock.Prev + IrqPCClock.Have - IrqPCClock.Step;
			IrqPCClock.Prev = pc_clock;
			IrqPSXClock.Prev += IrqPSXClock.Step;
            {
				long i;
				long irq_mask = 0;
				for( i = 0 ; i < 8 ; i++ )
				{
					if( IrqProcessing.Clock[i] < IrqPSXClock.Prev )
					{
						IrqFuncResult irq_result = IrqProcessing.Func[i]();
						irq_mask |= irq_result.l[0];
						IrqProcessing.Clock[i] += irq_result.l[1];
					}
				}
				if( irq_mask )
				{
					cpuIrqRequest( irq_mask );
				}
			}
		}
	}
}

/******************************************************************************/
/* Start */
long timingStart(void)
{
	IrqPCClock.Prev = GetPCClock();
	return 0;
}
/* Open */
long timingOpen(void)
{
	long i;
	for( i = 0 ; i < 8 ; i++ )
	{
		IrqProcessing.Clock[ i ] = 0x7fffffff;
		IrqProcessing.Func[ i ] = IrqDefFunc;
	}
	IrqPSXClock.Prev = 0;
	IrqPSXClock.Step = 1 << MainTimerInc;
	IrqPCClock.Step = ( Emulator -> Interface -> GetStepClock(1) << MainTimerInc )
		/ ( VSyncPerSecond[ cpuIrqMode ] * HSyncPerVSync[ cpuIrqMode ] );
	IrqPCClock.Have = 0;
	IrqPCClock.TimeCurrent = 0;
	IrqPCClock.TimeCheck = CheckTime;
	return 0;
}
