; SMS MMU emulator
; /Mic, 2004


.486
.model flat,stdcall
option casemap:none


include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
IFDEF _DEBUG_
include \masm32\include\user32.inc
ENDIF

includelib kernel32.lib
IFDEF _DEBUG_
includelib user32.lib
ENDIF


IFDEF _DEBUG_
	wsprintfA PROTO C :DWORD, :VARARG
	wsprintf equ <wsprintfA>
ENDIF


.data
	INPUT		equ 0
	OUTPUT		equ 1
	PAGE2TYPE	equ 8
	
paging_regs label byte
	ramSelect	db 0
	page0Bank	db 0
	page1Bank	db 0
	page2Bank	db 0


IFDEF _DEBUG_
	szFormatRAM	db "RAM select = %d",0
	szFormatPfr0	db "PFR0 = %d      ",0
	szFormatPfr1	db "PFR1 = %d      ",0
	szFormatPfr2	db "PFR2 = %d      ",0
	szReadRAM	db "Reading RAM select",0
	szReadPfr0	db "Reading PFR0",0
	szReadPfr2	db "Reading PFR2",0
	szInfo		db 64 DUP(0)
	szError		db "Error",0
ENDIF


.data?
	hInst	dd ?
	RAM	dd ?
	CRAM	dd ?
	Page0Low dd ?
	Page0	dd ?
	Page1	dd ?
	Page2	dd ?
	maxPage	dd ?
	

.code

LibMain PROC hInstDLL:DWORD, reason:DWORD, unused:DWORD

        .if reason == 1		;DLL_PROCESS_ATTACH
        	mov eax,hInstDLL
        	mov hInst,eax
		mov eax,TRUE
		ret

        .elseif reason == 0	;DLL_PROCESS_DETACH
        .elseif reason == 2	;DLL_THREAD_ATTACH
        .elseif reason == 3	;DLL_THREAD_DETACH
        .endif

        mov eax,FALSE
        ret
LibMain ENDP



inpb_null PROC
	ret
inpb_null ENDP
.data
inpb_handlers dd 256 DUP(OFFSET inpb_null)
.code

outpb_null PROC dat:DWORD
	ret
outpb_null ENDP
.data
outpb_handlers dd 256 DUP(OFFSET outpb_null)
.code	


mmu_init PROC
	invoke LocalAlloc,LPTR,32768
	mov CRAM,eax
	invoke LocalAlloc,LPTR,8192
	mov RAM,eax
	ret
mmu_init ENDP


mmu_reset PROC cart:DWORD,cartsize:DWORD
	mov eax,cart
	mov Page0Low,eax
	mov Page0,eax
	mov Page2,eax
	add eax,4000h
	mov Page1,eax
	
	mov eax,cartsize
	shr eax,14
	dec eax
	mov maxPage,eax
	
	ret
mmu_reset ENDP


mmu_close PROC
	invoke LocalFree,CRAM
	invoke LocalFree,RAM
	ret
mmu_close ENDP


mmu_get_ram_base PROC
	mov eax,RAM
	ret
mmu_get_ram_base ENDP



mmu_read_byte PROC address:DWORD
	push edi
	
	mov edi,address
	xor eax,eax
	
	.if edi < 00400h
		mov esi,Page0Low
		and edi,3FFh
		add esi,edi
		mov al,[esi]

	.elseif edi < 04000h
		mov esi,Page0
		and edi,3FFFh
		add esi,edi
		mov al,[esi]

	.elseif edi < 08000h
		mov esi,Page1
		and edi,3FFFh
		add esi,edi
		mov al,[esi]
	
	.elseif edi < 0C000h
		;IFDEF _DEBUG_
		;	pusha
		;	invoke MessageBox, NULL,ADDR szReadRAM,ADDR szError,MB_ICONERROR
		;	popa
		;ENDIF	
		mov esi,Page2
		and edi,3FFFh
		add esi,edi
		mov al,[esi]
	
	.else
		and edi,1FFFh
		.if edi < 1FFCh
			mov esi,RAM
			add esi,edi
			mov al,[esi]
		.else
			mov esi,OFFSET paging_regs
			and edi,3
			add esi,edi
			mov al,[esi]
		.endif
	.endif

	pop edi
	ret
mmu_read_byte ENDP



mmu_write_byte PROC address:DWORD,dat:DWORD
	mov edi,address
	
	.if edi < 0C000h 

	.else
		and edi,1FFFh
		
		.if edi < 1FFCh
			mov eax,dat
			add edi,RAM
			mov [edi],al

		.elseif edi == 1FFCh
			mov eax,dat
			mov ramSelect,al

			IFDEF _DEBUG_
			.if eax!=0
				pusha
				invoke wsprintf, ADDR szInfo,ADDR szFormatRAM,eax
				invoke MessageBox, NULL,ADDR szInfo,ADDR szError,MB_ICONERROR
				popa
			.endif
			ENDIF

			test al,8
			jz @@wb_fffc_disable_cram
				and eax,4
				shl eax,12
				add eax,CRAM
				mov Page2,eax
				jmp @@wb_fffc_done
			@@wb_fffc_disable_cram:
				movzx eax,page2Bank
				shl eax,14
				add eax,Page0Low
				mov Page2,eax
			@@wb_fffc_done:
		
		.elseif edi == 1FFDh
			mov eax,dat
			and eax,maxPage
			;IFDEF _DEBUG_
			;	pusha
			;	invoke wsprintf, ADDR szInfo,ADDR szFormatPfr0,eax
			;	invoke MessageBox, NULL,ADDR szInfo,ADDR szError,MB_ICONERROR
			;	popa
			;ENDIF
			mov page0Bank,al
			add edi,RAM
			mov [edi],al
			shl eax,14
			add eax,Page0Low
			mov Page0,eax
		
		.elseif edi == 1FFEh
			mov eax,dat
			and eax,maxPage
			mov page1Bank,al
			add edi,RAM
			mov [edi],al
			shl eax,14
			add eax,Page0Low
			mov Page1,eax

		.else
			mov eax,dat
			and eax,maxPage
			mov page2Bank,al
			IFDEF _DEBUG_
			.if eax!=0
				pusha
				invoke wsprintf, ADDR szInfo,ADDR szFormatPfr2,eax
				invoke MessageBox, NULL,ADDR szInfo,ADDR szError,MB_ICONERROR
				popa
			.endif
			ENDIF

			test ramSelect,8
			jz @@wb_ffff_rom
				movzx eax,ramSelect
				and eax,4
				shl eax,12
				add eax,CRAM
				mov Page2,eax
				jmp @@wb_ffff_done
			@@wb_ffff_rom:		
				shl eax,14
				add eax,Page0Low
				mov Page2,eax
			@@wb_ffff_done:
		.endif	
	.endif
	
	ret
mmu_write_byte ENDP



mmu_write_word PROC address:DWORD,dat:DWORD
	mov edi,address
	
	.if edi < 0C000h 

	.elseif edi < 0FFFCh
		and edi,1FFFh
		mov eax,dat
		add edi,RAM
		mov [edi],ax
	.endif	
	
	ret
mmu_write_word ENDP



mmu_set_io_handler PROC mode:DWORD,port:DWORD,pfhandler:DWORD
	push ebx

	mov eax,port
	mov ebx,pfhandler
	
	.if mode==INPUT	
		mov [inpb_handlers + eax*4],ebx
	.else
		mov [outpb_handlers + eax*4],ebx
	.endif
	
	pop ebx
	ret
mmu_set_io_handler ENDP



mmu_outpb PROC port:DWORD,dat:DWORD
	push ecx
	push dword ptr dat
	mov eax,port
	call dword ptr [outpb_handlers + eax*4]
	pop ecx
	ret
mmu_outpb ENDP


mmu_inpb PROC port:DWORD
	push ecx
	mov eax,port
	call dword ptr [inpb_handlers + eax*4]
	pop ecx
	ret
mmu_inpb ENDP


END LibMain
