/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class BufferChecks {
    private static final int DEFAULT_BUFFER_SIZE = 4;

    private BufferChecks() {
    }

    public static void checkFunctionAddress(long pointer) {
        if (pointer == 0L) {
            throw new IllegalStateException("Function is not supported");
        }
    }

    public static void checkNullTerminated(ByteBuffer buf) {
        if (buf.get(buf.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNotNull(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null argument");
        }
    }

    public static void checkDirectOrNull(ByteBuffer buf) {
        if (buf != null) {
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkDirectOrNull(FloatBuffer buf) {
        if (buf != null) {
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkDirectOrNull(ShortBuffer buf) {
        if (buf != null) {
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkDirectOrNull(IntBuffer buf) {
        if (buf != null) {
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkDirectOrNull(DoubleBuffer buf) {
        if (buf != null) {
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkDirectBuffer(Buffer buf) {
        if (buf instanceof ByteBuffer) {
            BufferChecks.checkDirect((ByteBuffer)buf);
        } else if (buf instanceof ShortBuffer) {
            BufferChecks.checkDirect((ShortBuffer)buf);
        } else if (buf instanceof IntBuffer) {
            BufferChecks.checkDirect((IntBuffer)buf);
        } else if (buf instanceof FloatBuffer) {
            BufferChecks.checkDirect((FloatBuffer)buf);
        } else if (buf instanceof DoubleBuffer) {
            BufferChecks.checkDirect((DoubleBuffer)buf);
        } else {
            throw new IllegalStateException("Unsupported buffer type");
        }
    }

    public static void checkDirect(ByteBuffer buf) {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer is not direct");
        }
    }

    public static void checkDirect(FloatBuffer buf) {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("FloatBuffer is not direct");
        }
    }

    public static void checkDirect(ShortBuffer buf) {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("ShortBuffer is not direct");
        }
    }

    public static void checkDirect(IntBuffer buf) {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("IntBuffer is not direct");
        }
    }

    public static void checkDirect(DoubleBuffer buf) {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("IntBuffer is not direct");
        }
    }

    private static void checkBufferSize(Buffer buf, int size) {
        if (buf.remaining() < size) {
            throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size);
        }
    }

    public static void checkBuffer(ByteBuffer buf, int size) {
        BufferChecks.checkBufferSize(buf, size);
        BufferChecks.checkDirect(buf);
    }

    public static void checkBuffer(IntBuffer buf, int size) {
        BufferChecks.checkBufferSize(buf, size);
        BufferChecks.checkDirect(buf);
    }

    public static void checkBuffer(ShortBuffer buf, int size) {
        BufferChecks.checkBufferSize(buf, size);
        BufferChecks.checkDirect(buf);
    }

    public static void checkBuffer(FloatBuffer buf, int size) {
        BufferChecks.checkBufferSize(buf, size);
        BufferChecks.checkDirect(buf);
    }

    public static void checkBuffer(DoubleBuffer buf, int size) {
        BufferChecks.checkBufferSize(buf, size);
        BufferChecks.checkDirect(buf);
    }

    public static void checkBuffer(ByteBuffer buf) {
        BufferChecks.checkBuffer(buf, 4);
    }

    public static void checkBuffer(ShortBuffer buf) {
        BufferChecks.checkBuffer(buf, 4);
    }

    public static void checkBuffer(FloatBuffer buf) {
        BufferChecks.checkBuffer(buf, 4);
    }

    public static void checkBuffer(IntBuffer buf) {
        BufferChecks.checkBuffer(buf, 4);
    }

    public static void checkBuffer(DoubleBuffer buf) {
        BufferChecks.checkBuffer(buf, 4);
    }
}

