/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;

public final class AL {
    protected static ALCdevice device;
    protected static ALCcontext context;
    private static boolean created;

    private AL() {
    }

    private static native void nCreate(String[] var0) throws LWJGLException;

    private static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    public static void create(String deviceArguments, int contextFrequency, int contextRefresh, boolean contextSynchronized) throws LWJGLException {
        if (created) {
            throw new IllegalStateException("Only one OpenAL context may be instantiated at any one time.");
        }
        String[] oalPaths = LWJGLUtil.getLibraryPaths(new String[]{"OpenAL32", "OpenAL32.dll", "openal", "libopenal.so", "openal", "openal.dylib"}, AL.class.getClassLoader());
        LWJGLUtil.log("Found " + oalPaths.length + " OpenAL paths");
        AL.nCreate(oalPaths);
        created = true;
        try {
            AL10.initNativeStubs();
            ALC.initNativeStubs();
            device = ALC.alcOpenDevice(deviceArguments);
            if (device == null) {
                throw new LWJGLException("Could not open ALC device");
            }
            context = contextFrequency == -1 ? ALC.alcCreateContext(AL.device.device, null) : ALC.alcCreateContext(AL.device.device, ALCcontext.createAttributeList(contextFrequency, contextRefresh, contextSynchronized ? 1 : 0));
            ALC.alcMakeContextCurrent(AL.context.context);
        }
        catch (LWJGLException e) {
            AL.destroy();
            throw e;
        }
    }

    public static void create() throws LWJGLException {
        AL.create(null, 44100, 60, false);
    }

    public static void destroy() {
        if (context != null) {
            ALC.alcDestroyContext(AL.context.context);
            context = null;
        }
        if (device != null) {
            ALC.alcCloseDevice(AL.device.device);
            device = null;
        }
        AL.resetNativeStubs(AL10.class);
        AL.resetNativeStubs(ALC.class);
        if (created) {
            AL.nDestroy();
        }
        created = false;
    }

    private static native void resetNativeStubs(Class var0);

    public static Object getContext() {
        return context;
    }

    static {
        Sys.initialize();
    }
}

