// ****************************************************************************
// * This file is part of the xBRZ project. It is distributed under           *
// * GNU General Public License: http://www.gnu.org/licenses/gpl-3.0          *
// * Copyright (C) Zenju (zenju AT gmx DOT de) - All Rights Reserved          *
// ****************************************************************************

#ifndef KEGA_PLUGIN_H_018346708475603485628745
#define KEGA_PLUGIN_H_018346708475603485628745

#include <zen/win.h>

//Kega FusionPlugin API

struct RENDER_PLUGIN_OUTP
{
    unsigned long Size;
    unsigned long Flags;
    void* SrcPtr;
    unsigned long SrcPitch;
    unsigned long SrcW;
    unsigned long SrcH;
    void* DstPtr;
    unsigned long DstPitch;
    unsigned long DstW;
    unsigned long DstH;
    unsigned long OutW; //"the size of the image you actually produced. This has no effect currently but will at a later date."
    unsigned long OutH; //
};

using RENDPLUG_Output = void (*)(RENDER_PLUGIN_OUTP*);

struct RENDER_PLUGIN_INFO
{
    char Name[60];
    unsigned long Flags;
    HMODULE Handle;
    RENDPLUG_Output Output;
};


#define RPI_VERSION     0x02

#define RPI_MMX_USED    0x000000100
#define RPI_MMX_REQD    0x000000200

#define RPI_555_SUPP    0x000000400
#define RPI_565_SUPP    0x000000800
#define RPI_888_SUPP    0x000001000 //still unsupported by Kega Fusion v3.64

#define RPI_DST_WIDE    0x000008000

#define RPI_OUT_SCL1    0x000010000
#define RPI_OUT_SCL2    0x000020000
#define RPI_OUT_SCL3    0x000030000
#define RPI_OUT_SCL4    0x000040000

#define RPI_OUT_SCLMSK  0x0000f0000
#define RPI_OUT_SCLSH   16

#endif //KEGA_PLUGIN_H_018346708475603485628745
