/*
 * Decompiled with CFR 0.152.
 */
class NoiseGenerator {
    public static final int CHAN_LEFT = 1;
    public static final int CHAN_RIGHT = 2;
    public static final int CHAN_MONO = 4;
    int totalLength;
    int cyclePos;
    int cycleLength;
    int amplitude;
    int channel;
    int sampleRate;
    int initialEnvelope;
    int numStepsEnvelope;
    boolean increaseEnvelope;
    int counterEnvelope;

    public NoiseGenerator(int n, int n2, int n3, int n4) {
        this.cycleLength = n;
        this.amplitude = n2;
        this.cyclePos = 0;
        this.channel = n3;
        this.sampleRate = n4;
    }

    public NoiseGenerator(int n) {
        this.cyclePos = 0;
        this.channel = 3;
        this.cycleLength = 2;
        this.totalLength = 0;
        this.sampleRate = n;
        this.amplitude = 32;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setEnvelope(int n, int n2, boolean bl) {
        this.initialEnvelope = n;
        this.numStepsEnvelope = n2;
        this.increaseEnvelope = bl;
        this.amplitude = n * 2;
    }

    public int getLength() {
        return this.totalLength;
    }

    public void setLength(int n) {
        this.totalLength = n == -1 ? -1 : (64 - n) / 4;
    }

    public void play(byte[] byArray, int n, int n2) {
        if (this.totalLength != 0) {
            --this.totalLength;
            ++this.counterEnvelope;
            if (this.numStepsEnvelope != 0 && this.counterEnvelope % this.numStepsEnvelope == 0 && this.amplitude > 0) {
                if (!this.increaseEnvelope) {
                    if (this.amplitude > 0) {
                        this.amplitude -= 2;
                    }
                } else if (this.amplitude < 16) {
                    this.amplitude += 2;
                }
            }
            for (int i = n2; i < n2 + n; ++i) {
                int n3 = (int)(Math.random() * (double)this.amplitude * 2.0 - (double)this.amplitude);
                if ((this.channel & 1) != 0) {
                    int n4 = i * 2;
                    byArray[n4] = (byte)(byArray[n4] + n3);
                }
                if ((this.channel & 2) != 0) {
                    int n5 = i * 2 + 1;
                    byArray[n5] = (byte)(byArray[n5] + n3);
                }
                if ((this.channel & 4) != 0) {
                    int n6 = i;
                    byArray[n6] = (byte)(byArray[n6] + n3);
                }
                this.cyclePos = (this.cyclePos + 256) % this.cycleLength;
            }
        }
    }
}

