/*
 * Decompiled with CFR 0.152.
 */
public final class PgbCpu {
    private final int HALTON = -1;
    static final int Z_FLAG = 128;
    static final int N_FLAG = 64;
    static final int H_FLAG = 32;
    static final int C_FLAG = 16;
    PgbMemory mem;
    private PgbRegister BC;
    private PgbRegister DE;
    private PgbRegister HL;
    private PgbRegisterW SP;
    private PgbRegisterW PC;
    private PgbRegisterB AF;
    private boolean ime;
    SoundChip soundChip;

    public PgbCpu(PgbMemory pgbMemory) {
        this.mem = pgbMemory;
    }

    public void reset() {
        this.AF = new PgbRegisterB(384);
        if (PgbSettings.system == 1) {
            this.AF = new PgbRegisterB(65408);
        }
        if (PgbSettings.system == 11) {
            this.AF = new PgbRegisterB(4480);
        }
        this.BC = new PgbRegisterB(19);
        this.DE = new PgbRegisterB(216);
        this.HL = new PgbRegisterW(333);
        this.SP = new PgbRegisterW(65534);
        this.PC = new PgbRegisterW(256);
        this.ime = false;
        PgbSettings.clockspeed = 4.194304;
    }

    public final void exec(int n) {
        while (n > 0) {
            if (this.ime && (this.mem.IF & this.mem.IE) != 0) {
                this.interrupt(this.mem.IF & this.mem.IE);
            }
            int n2 = this.mem.read(this.PC.data++) & 0xFF;
            int n3 = 4;
            block0 : switch (n2) {
                case 0: {
                    n3 = 4;
                    break;
                }
                case 1: {
                    this.BC.setR(this.readWord());
                    n3 = 20;
                    break;
                }
                case 2: {
                    this.mem.write(this.BC.getR(), this.AF.getH());
                    n3 = 8;
                    break;
                }
                case 3: {
                    this.incR(this.BC);
                    n3 = 8;
                    break;
                }
                case 4: {
                    this.incH(this.BC);
                    n3 = 4;
                    break;
                }
                case 5: {
                    this.decH(this.BC);
                    n3 = 4;
                    break;
                }
                case 6: {
                    this.BC.setH(this.readByte());
                    n3 = 8;
                    break;
                }
                case 7: {
                    this.rlcH(this.AF);
                    this.setZ(false);
                    n3 = 4;
                    break;
                }
                case 8: {
                    this.mem.writeWord(this.readWord(), this.SP.getR());
                    n3 = 20;
                    break;
                }
                case 9: {
                    this.addR(this.HL, this.BC);
                    n3 = 12;
                    break;
                }
                case 10: {
                    this.AF.setH(this.BC.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 11: {
                    this.decR(this.BC);
                    n3 = 8;
                    break;
                }
                case 12: {
                    this.incL(this.BC);
                    n3 = 4;
                    break;
                }
                case 13: {
                    this.decL(this.BC);
                    n3 = 4;
                    break;
                }
                case 14: {
                    this.BC.setL(this.readByte());
                    n3 = 8;
                    break;
                }
                case 15: {
                    this.rrcH(this.AF);
                    this.setZ(false);
                    n3 = 4;
                    break;
                }
                case 16: {
                    this.readByte();
                    if (PgbSettings.system == 11) {
                        if ((this.mem.gbcGetSpeed() & 1) == 1) {
                            PgbSettings.clockspeed = 8.388;
                            this.mem.gbcSetSpeed((byte)-128);
                        } else {
                            PgbSettings.clockspeed = 4.194;
                            this.mem.gbcSetSpeed((byte)0);
                        }
                    } else {
                        this.unsupported(16);
                    }
                    n3 = 4;
                    break;
                }
                case 17: {
                    this.DE.setR(this.readWord());
                    n3 = 12;
                    break;
                }
                case 18: {
                    this.DE.setI(this.AF.getH(), this.mem);
                    n3 = 8;
                    break;
                }
                case 19: {
                    this.incR(this.DE);
                    n3 = 8;
                    break;
                }
                case 20: {
                    this.incH(this.DE);
                    n3 = 4;
                    break;
                }
                case 21: {
                    this.decH(this.DE);
                    n3 = 4;
                    break;
                }
                case 22: {
                    this.DE.setH(this.readByte());
                    n3 = 8;
                    break;
                }
                case 23: {
                    this.rlH(this.AF);
                    this.setZ(false);
                    n3 = 4;
                    break;
                }
                case 24: {
                    this.jr(this.readByte());
                    n3 = 12;
                    break;
                }
                case 25: {
                    this.addR(this.HL, this.DE);
                    n3 = 16;
                    break;
                }
                case 26: {
                    this.AF.setH(this.DE.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 27: {
                    this.decR(this.DE);
                    n3 = 8;
                    break;
                }
                case 28: {
                    this.incL(this.DE);
                    n3 = 4;
                    break;
                }
                case 29: {
                    this.decL(this.DE);
                    n3 = 4;
                    break;
                }
                case 30: {
                    this.DE.setL(this.readByte());
                    n3 = 8;
                    break;
                }
                case 31: {
                    this.rrH(this.AF);
                    this.setZ(false);
                    n3 = 4;
                    break;
                }
                case 32: {
                    if (!this.getZ()) {
                        this.jr(this.readByte());
                        n3 = 12;
                        break;
                    }
                    this.readByte();
                    n3 = 8;
                    break;
                }
                case 33: {
                    this.HL.setR(this.readWord());
                    n3 = 12;
                    break;
                }
                case 34: {
                    this.HL.setI(this.AF.getH(), this.mem);
                    this.incR(this.HL);
                    n3 = 16;
                    break;
                }
                case 35: {
                    this.incR(this.HL);
                    n3 = 8;
                    break;
                }
                case 36: {
                    this.incH(this.HL);
                    n3 = 4;
                    break;
                }
                case 37: {
                    this.decH(this.HL);
                    n3 = 4;
                    break;
                }
                case 38: {
                    this.HL.setH(this.readByte());
                    n3 = 8;
                    break;
                }
                case 39: {
                    this.daa();
                    n3 = 4;
                    break;
                }
                case 40: {
                    if (this.getZ()) {
                        this.jr(this.readByte());
                        n3 = 12;
                        break;
                    }
                    this.readByte();
                    n3 = 8;
                    break;
                }
                case 41: {
                    this.addR(this.HL, this.HL);
                    n3 = 12;
                    break;
                }
                case 42: {
                    this.AF.setH(this.HL.getI(this.mem));
                    this.incR(this.HL);
                    n3 = 16;
                    break;
                }
                case 43: {
                    this.decR(this.HL);
                    n3 = 8;
                    break;
                }
                case 44: {
                    this.incL(this.HL);
                    n3 = 4;
                    break;
                }
                case 45: {
                    this.decL(this.HL);
                    n3 = 4;
                    break;
                }
                case 46: {
                    this.HL.setL(this.readByte());
                    n3 = 8;
                    break;
                }
                case 47: {
                    this.cpl();
                    n3 = 4;
                    break;
                }
                case 48: {
                    if (!this.getC()) {
                        this.jr(this.readByte());
                        n3 = 12;
                        break;
                    }
                    this.readByte();
                    n3 = 8;
                    break;
                }
                case 49: {
                    this.SP.setR(this.readWord());
                    n3 = 12;
                    break;
                }
                case 50: {
                    this.HL.setI(this.AF.getH(), this.mem);
                    this.decR(this.HL);
                    n3 = 16;
                    break;
                }
                case 51: {
                    this.incR(this.SP);
                    n3 = 8;
                    break;
                }
                case 52: {
                    this.incI(this.HL);
                    n3 = 12;
                    break;
                }
                case 53: {
                    this.decI(this.HL);
                    n3 = 12;
                    break;
                }
                case 54: {
                    this.HL.setI(this.readByte(), this.mem);
                    n3 = 12;
                    break;
                }
                case 55: {
                    this.setC(true);
                    n3 = 4;
                    break;
                }
                case 56: {
                    if (this.getC()) {
                        this.jr(this.readByte());
                        n3 = 12;
                        break;
                    }
                    this.readByte();
                    n3 = 8;
                    break;
                }
                case 57: {
                    this.addR(this.HL, this.SP);
                    n3 = 12;
                    break;
                }
                case 58: {
                    this.AF.setH(this.HL.getI(this.mem));
                    this.decR(this.HL);
                    n3 = 16;
                    break;
                }
                case 59: {
                    this.decR(this.SP);
                    n3 = 8;
                    break;
                }
                case 60: {
                    this.incH(this.AF);
                    n3 = 4;
                    break;
                }
                case 61: {
                    this.decH(this.AF);
                    n3 = 4;
                    break;
                }
                case 62: {
                    this.AF.setH(this.readByte());
                    n3 = 8;
                    break;
                }
                case 63: {
                    this.setC(!this.getC());
                    n3 = 4;
                    break;
                }
                case 64: {
                    n3 = 4;
                    break;
                }
                case 65: {
                    this.BC.setH(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 66: {
                    this.BC.setH(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 67: {
                    this.BC.setH(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 68: {
                    this.BC.setH(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 69: {
                    this.BC.setH(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 70: {
                    this.BC.setH(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 71: {
                    this.BC.setH(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 72: {
                    this.BC.setL(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 73: {
                    n3 = 4;
                    break;
                }
                case 74: {
                    this.BC.setL(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 75: {
                    this.BC.setL(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 76: {
                    this.BC.setL(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 77: {
                    this.BC.setL(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 78: {
                    this.BC.setL(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 79: {
                    this.BC.setL(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 80: {
                    this.DE.setH(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 81: {
                    this.DE.setH(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 82: {
                    n3 = 4;
                    break;
                }
                case 83: {
                    this.DE.setH(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 84: {
                    this.DE.setH(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 85: {
                    this.DE.setH(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 86: {
                    this.DE.setH(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 87: {
                    this.DE.setH(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 88: {
                    this.DE.setL(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 89: {
                    this.DE.setL(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 90: {
                    this.DE.setL(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 91: {
                    n3 = 4;
                    break;
                }
                case 92: {
                    this.DE.setL(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 93: {
                    this.DE.setL(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 94: {
                    this.DE.setL(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 95: {
                    this.DE.setL(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 96: {
                    this.HL.setH(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 97: {
                    this.HL.setH(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 98: {
                    this.HL.setH(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 99: {
                    this.HL.setH(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 100: {
                    n3 = 4;
                    break;
                }
                case 101: {
                    this.HL.setH(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 102: {
                    this.HL.setH(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 103: {
                    this.HL.setH(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 104: {
                    this.HL.setL(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 105: {
                    this.HL.setL(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 106: {
                    this.HL.setL(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 107: {
                    this.HL.setL(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 108: {
                    this.HL.setL(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 109: {
                    n3 = 4;
                    break;
                }
                case 110: {
                    this.HL.setL(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 111: {
                    this.HL.setL(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 112: {
                    this.mem.write(this.HL.getR(), this.BC.getH());
                    n3 = 8;
                    break;
                }
                case 113: {
                    this.mem.write(this.HL.getR(), this.BC.getL());
                    n3 = 8;
                    break;
                }
                case 114: {
                    this.mem.write(this.HL.getR(), this.DE.getH());
                    n3 = 8;
                    break;
                }
                case 115: {
                    this.mem.write(this.HL.getR(), this.DE.getL());
                    n3 = 8;
                    break;
                }
                case 116: {
                    this.mem.write(this.HL.getR(), this.HL.getH());
                    n3 = 8;
                    break;
                }
                case 117: {
                    this.mem.write(this.HL.getR(), this.HL.getL());
                    n3 = 8;
                    break;
                }
                case 118: {
                    if (this.ime) {
                        this.mem.recalcCyclesLeft();
                        n3 = this.mem.cyclesLeft;
                        break;
                    }
                    n3 = 4;
                    break;
                }
                case 119: {
                    this.mem.write(this.HL.getR(), this.AF.getH());
                    n3 = 8;
                    break;
                }
                case 120: {
                    this.AF.setH(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 121: {
                    this.AF.setH(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 122: {
                    this.AF.setH(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 123: {
                    this.AF.setH(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 124: {
                    this.AF.setH(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 125: {
                    this.AF.setH(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 126: {
                    this.AF.setH(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 127: {
                    n3 = 4;
                    break;
                }
                case 128: {
                    this.add(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 129: {
                    this.add(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 130: {
                    this.add(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 131: {
                    this.add(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 132: {
                    this.add(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 133: {
                    this.add(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 134: {
                    this.add(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 135: {
                    this.add(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 136: {
                    this.adc(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 137: {
                    this.adc(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 138: {
                    this.adc(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 139: {
                    this.adc(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 140: {
                    this.adc(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 141: {
                    this.adc(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 142: {
                    this.adc(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 143: {
                    this.adc(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 144: {
                    this.sub(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 145: {
                    this.sub(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 146: {
                    this.sub(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 147: {
                    this.sub(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 148: {
                    this.sub(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 149: {
                    this.sub(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 150: {
                    this.sub(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 151: {
                    this.sub(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 152: {
                    this.sbc(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 153: {
                    this.sbc(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 154: {
                    this.sbc(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 155: {
                    this.sbc(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 156: {
                    this.sbc(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 157: {
                    this.sbc(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 158: {
                    this.sbc(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 159: {
                    this.sbc(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 160: {
                    this.and(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 161: {
                    this.and(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 162: {
                    this.and(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 163: {
                    this.and(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 164: {
                    this.and(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 165: {
                    this.and(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 166: {
                    this.and(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 167: {
                    this.and(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 168: {
                    this.xor(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 169: {
                    this.xor(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 170: {
                    this.xor(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 171: {
                    this.xor(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 172: {
                    this.xor(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 173: {
                    this.xor(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 174: {
                    this.xor(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 175: {
                    this.xor(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 176: {
                    this.or(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 177: {
                    this.or(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 178: {
                    this.or(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 179: {
                    this.or(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 180: {
                    this.or(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 181: {
                    this.or(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 182: {
                    this.or(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 183: {
                    this.or(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 184: {
                    this.cp(this.BC.getH());
                    n3 = 4;
                    break;
                }
                case 185: {
                    this.cp(this.BC.getL());
                    n3 = 4;
                    break;
                }
                case 186: {
                    this.cp(this.DE.getH());
                    n3 = 4;
                    break;
                }
                case 187: {
                    this.cp(this.DE.getL());
                    n3 = 4;
                    break;
                }
                case 188: {
                    this.cp(this.HL.getH());
                    n3 = 4;
                    break;
                }
                case 189: {
                    this.cp(this.HL.getL());
                    n3 = 4;
                    break;
                }
                case 190: {
                    this.cp(this.HL.getI(this.mem));
                    n3 = 8;
                    break;
                }
                case 191: {
                    this.cp(this.AF.getH());
                    n3 = 4;
                    break;
                }
                case 192: {
                    if (!this.getZ()) {
                        this.ret();
                        n3 = 20;
                        break;
                    }
                    n3 = 8;
                    break;
                }
                case 193: {
                    this.pop(this.BC);
                    n3 = 12;
                    break;
                }
                case 194: {
                    if (!this.getZ()) {
                        this.jp(this.readWord());
                        n3 = 16;
                        break;
                    }
                    this.readWord();
                    n3 = 12;
                    break;
                }
                case 195: {
                    this.jp(this.readWord());
                    n3 = 16;
                    break;
                }
                case 196: {
                    if (!this.getZ()) {
                        this.call(this.readWord());
                        n3 = 24;
                        break;
                    }
                    this.readWord();
                    n3 = 12;
                    break;
                }
                case 197: {
                    this.push(this.BC);
                    n3 = 16;
                    break;
                }
                case 198: {
                    this.add(this.readByte());
                    n3 = 8;
                    break;
                }
                case 199: {
                    this.rst(0);
                    n3 = 16;
                    break;
                }
                case 200: {
                    if (this.getZ()) {
                        this.ret();
                        n3 = 20;
                        break;
                    }
                    n3 = 8;
                    break;
                }
                case 201: {
                    this.ret();
                    n3 = 16;
                    break;
                }
                case 202: {
                    if (this.getZ()) {
                        this.jp(this.readWord());
                        n3 = 16;
                        break;
                    }
                    this.readWord();
                    n3 = 12;
                    break;
                }
                case 203: {
                    int n4 = this.readByte();
                    switch (n4) {
                        case 0: {
                            this.rlcH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 1: {
                            this.rlcL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 2: {
                            this.rlcH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 3: {
                            this.rlcL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 4: {
                            this.rlcH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 5: {
                            this.rlcL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 6: {
                            this.rlcI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 7: {
                            this.rlcH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 8: {
                            this.rrcH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 9: {
                            this.rrcL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 10: {
                            this.rrcH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 11: {
                            this.rrcL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 12: {
                            this.rrcH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 13: {
                            this.rrcL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 14: {
                            this.rrcI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 15: {
                            this.rrcH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 16: {
                            this.rlH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 17: {
                            this.rlL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 18: {
                            this.rlH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 19: {
                            this.rlL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 20: {
                            this.rlH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 21: {
                            this.rlL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 22: {
                            this.rlI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 23: {
                            this.rlH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 24: {
                            this.rrH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 25: {
                            this.rrL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 26: {
                            this.rrH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 27: {
                            this.rrL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 28: {
                            this.rrH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 29: {
                            this.rrL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 30: {
                            this.rrI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 31: {
                            this.rrH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 32: {
                            this.slaH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 33: {
                            this.slaL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 34: {
                            this.slaH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 35: {
                            this.slaL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 36: {
                            this.slaH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 37: {
                            this.slaL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 38: {
                            this.slaI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 39: {
                            this.slaH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 40: {
                            this.sraH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 41: {
                            this.sraL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 42: {
                            this.sraH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 43: {
                            this.sraL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 44: {
                            this.sraH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 45: {
                            this.sraL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 46: {
                            this.sraI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 47: {
                            this.sraH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 48: {
                            this.swapH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 49: {
                            this.swapL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 50: {
                            this.swapH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 51: {
                            this.swapL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 52: {
                            this.swapH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 53: {
                            this.swapL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 54: {
                            this.swapI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 55: {
                            this.swapH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 56: {
                            this.srlH(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 57: {
                            this.srlL(this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 58: {
                            this.srlH(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 59: {
                            this.srlL(this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 60: {
                            this.srlH(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 61: {
                            this.srlL(this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 62: {
                            this.srlI(this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 63: {
                            this.srlH(this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 64: {
                            this.bit(0, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 65: {
                            this.bit(0, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 66: {
                            this.bit(0, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 67: {
                            this.bit(0, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 68: {
                            this.bit(0, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 69: {
                            this.bit(0, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 70: {
                            this.bit(0, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 71: {
                            this.bit(0, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 72: {
                            this.bit(1, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 73: {
                            this.bit(1, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 74: {
                            this.bit(1, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 75: {
                            this.bit(1, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 76: {
                            this.bit(1, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 77: {
                            this.bit(1, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 78: {
                            this.bit(1, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 79: {
                            this.bit(1, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 80: {
                            this.bit(2, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 81: {
                            this.bit(2, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 82: {
                            this.bit(2, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 83: {
                            this.bit(2, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 84: {
                            this.bit(2, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 85: {
                            this.bit(2, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 86: {
                            this.bit(2, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 87: {
                            this.bit(2, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 88: {
                            this.bit(3, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 89: {
                            this.bit(3, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 90: {
                            this.bit(3, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 91: {
                            this.bit(3, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 92: {
                            this.bit(3, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 93: {
                            this.bit(3, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 94: {
                            this.bit(3, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 95: {
                            this.bit(3, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 96: {
                            this.bit(4, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 97: {
                            this.bit(4, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 98: {
                            this.bit(4, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 99: {
                            this.bit(4, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 100: {
                            this.bit(4, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 101: {
                            this.bit(4, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 102: {
                            this.bit(4, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 103: {
                            this.bit(4, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 104: {
                            this.bit(5, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 105: {
                            this.bit(5, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 106: {
                            this.bit(5, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 107: {
                            this.bit(5, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 108: {
                            this.bit(5, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 109: {
                            this.bit(5, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 110: {
                            this.bit(5, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 111: {
                            this.bit(5, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 112: {
                            this.bit(6, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 113: {
                            this.bit(6, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 114: {
                            this.bit(6, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 115: {
                            this.bit(6, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 116: {
                            this.bit(6, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 117: {
                            this.bit(6, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 118: {
                            this.bit(6, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 119: {
                            this.bit(6, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 120: {
                            this.bit(7, this.BC.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 121: {
                            this.bit(7, this.BC.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 122: {
                            this.bit(7, this.DE.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 123: {
                            this.bit(7, this.DE.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 124: {
                            this.bit(7, this.HL.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 125: {
                            this.bit(7, this.HL.getL());
                            n3 = 8;
                            break block0;
                        }
                        case 126: {
                            this.bit(7, this.HL.getI(this.mem));
                            n3 = 16;
                            break block0;
                        }
                        case 127: {
                            this.bit(7, this.AF.getH());
                            n3 = 8;
                            break block0;
                        }
                        case 128: {
                            this.resH(0, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 129: {
                            this.resL(0, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 130: {
                            this.resH(0, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 131: {
                            this.resL(0, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 132: {
                            this.resH(0, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 133: {
                            this.resL(0, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 134: {
                            this.resI(0, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 135: {
                            this.resH(0, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 136: {
                            this.resH(1, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 137: {
                            this.resL(1, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 138: {
                            this.resH(1, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 139: {
                            this.resL(1, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 140: {
                            this.resH(1, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 141: {
                            this.resL(1, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 142: {
                            this.resI(1, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 143: {
                            this.resH(1, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 144: {
                            this.resH(2, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 145: {
                            this.resL(2, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 146: {
                            this.resH(2, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 147: {
                            this.resL(2, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 148: {
                            this.resH(2, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 149: {
                            this.resL(2, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 150: {
                            this.resI(2, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 151: {
                            this.resH(2, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 152: {
                            this.resH(3, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 153: {
                            this.resL(3, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 154: {
                            this.resH(3, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 155: {
                            this.resL(3, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 156: {
                            this.resH(3, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 157: {
                            this.resL(3, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 158: {
                            this.resI(3, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 159: {
                            this.resH(3, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 160: {
                            this.resH(4, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 161: {
                            this.resL(4, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 162: {
                            this.resH(4, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 163: {
                            this.resL(4, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 164: {
                            this.resH(4, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 165: {
                            this.resL(4, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 166: {
                            this.resI(4, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 167: {
                            this.resH(4, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 168: {
                            this.resH(5, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 169: {
                            this.resL(5, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 170: {
                            this.resH(5, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 171: {
                            this.resL(5, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 172: {
                            this.resH(5, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 173: {
                            this.resL(5, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 174: {
                            this.resI(5, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 175: {
                            this.resH(5, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 176: {
                            this.resH(6, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 177: {
                            this.resL(6, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 178: {
                            this.resH(6, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 179: {
                            this.resL(6, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 180: {
                            this.resH(6, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 181: {
                            this.resL(6, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 182: {
                            this.resI(6, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 183: {
                            this.resH(6, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 184: {
                            this.resH(7, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 185: {
                            this.resL(7, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 186: {
                            this.resH(7, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 187: {
                            this.resL(7, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 188: {
                            this.resH(7, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 189: {
                            this.resL(7, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 190: {
                            this.resI(7, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 191: {
                            this.resH(7, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 192: {
                            this.setH(0, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 193: {
                            this.setL(0, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 194: {
                            this.setH(0, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 195: {
                            this.setL(0, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 196: {
                            this.setH(0, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 197: {
                            this.setL(0, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 198: {
                            this.setI(0, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 199: {
                            this.setH(0, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 200: {
                            this.setH(1, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 201: {
                            this.setL(1, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 202: {
                            this.setH(1, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 203: {
                            this.setL(1, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 204: {
                            this.setH(1, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 205: {
                            this.setL(1, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 206: {
                            this.setI(1, this.HL.getR());
                            n3 = 8;
                            break block0;
                        }
                        case 207: {
                            this.setH(1, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 208: {
                            this.setH(2, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 209: {
                            this.setL(2, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 210: {
                            this.setH(2, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 211: {
                            this.setL(2, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 212: {
                            this.setH(2, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 213: {
                            this.setL(2, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 214: {
                            this.setI(2, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 215: {
                            this.setH(2, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 216: {
                            this.setH(3, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 217: {
                            this.setL(3, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 218: {
                            this.setH(3, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 219: {
                            this.setL(3, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 220: {
                            this.setH(3, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 221: {
                            this.setL(3, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 222: {
                            this.setI(3, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 223: {
                            this.setH(3, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 224: {
                            this.setH(4, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 225: {
                            this.setL(4, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 226: {
                            this.setH(4, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 227: {
                            this.setL(4, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 228: {
                            this.setH(4, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 229: {
                            this.setL(4, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 230: {
                            this.setI(4, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 231: {
                            this.setH(4, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 232: {
                            this.setH(5, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 233: {
                            this.setL(5, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 234: {
                            this.setH(5, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 235: {
                            this.setL(5, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 236: {
                            this.setH(5, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 237: {
                            this.setL(5, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 238: {
                            this.setI(5, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 239: {
                            this.setH(5, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 240: {
                            this.setH(6, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 241: {
                            this.setL(6, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 242: {
                            this.setH(6, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 243: {
                            this.setL(6, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 244: {
                            this.setH(6, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 245: {
                            this.setL(6, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 246: {
                            this.setI(6, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 247: {
                            this.setH(6, this.AF);
                            n3 = 8;
                            break block0;
                        }
                        case 248: {
                            this.setH(7, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 249: {
                            this.setL(7, this.BC);
                            n3 = 8;
                            break block0;
                        }
                        case 250: {
                            this.setH(7, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 251: {
                            this.setL(7, this.DE);
                            n3 = 8;
                            break block0;
                        }
                        case 252: {
                            this.setH(7, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 253: {
                            this.setL(7, this.HL);
                            n3 = 8;
                            break block0;
                        }
                        case 254: {
                            this.setI(7, this.HL.getR());
                            n3 = 16;
                            break block0;
                        }
                        case 255: {
                            this.setH(7, this.AF);
                            n3 = 8;
                            break block0;
                        }
                    }
                    this.unsupportedCB(n4);
                    n3 = 4;
                    break;
                }
                case 204: {
                    if (this.getZ()) {
                        this.call(this.readWord());
                        n3 = 24;
                        break;
                    }
                    this.readWord();
                    n3 = 12;
                    break;
                }
                case 205: {
                    this.call(this.readWord());
                    n3 = 24;
                    break;
                }
                case 206: {
                    this.adc(this.readByte());
                    n3 = 8;
                    break;
                }
                case 207: {
                    this.rst(8);
                    n3 = 16;
                    break;
                }
                case 208: {
                    if (!this.getC()) {
                        this.ret();
                        n3 = 20;
                        break;
                    }
                    n3 = 8;
                    break;
                }
                case 209: {
                    this.pop(this.DE);
                    n3 = 10;
                    break;
                }
                case 210: {
                    if (!this.getC()) {
                        this.jp(this.readWord());
                        n3 = 20;
                        break;
                    }
                    this.readWord();
                    n3 = 8;
                    break;
                }
                case 211: {
                    this.unsupported(211);
                    n3 = 4;
                    break;
                }
                case 212: {
                    if (!this.getC()) {
                        this.call(this.readWord());
                        n3 = 24;
                        break;
                    }
                    this.readWord();
                    n3 = 12;
                    break;
                }
                case 213: {
                    this.push(this.DE);
                    n3 = 16;
                    break;
                }
                case 214: {
                    this.sub(this.readByte());
                    n3 = 8;
                    break;
                }
                case 215: {
                    this.rst(16);
                    n3 = 16;
                    break;
                }
                case 216: {
                    if (this.getC()) {
                        this.ret();
                        n3 = 20;
                        break;
                    }
                    n3 = 8;
                    break;
                }
                case 217: {
                    this.ret();
                    this.ei();
                    n3 = 16;
                    break;
                }
                case 218: {
                    if (this.getC()) {
                        this.jp(this.readWord());
                        n3 = 16;
                        break;
                    }
                    this.readWord();
                    n3 = 12;
                    break;
                }
                case 219: {
                    this.unsupported(219);
                    n3 = 4;
                    break;
                }
                case 220: {
                    if (this.getC()) {
                        this.call(this.readWord());
                        n3 = 24;
                        break;
                    }
                    this.readWord();
                    n3 = 12;
                    break;
                }
                case 221: {
                    this.unsupported(221);
                    n3 = 4;
                    break;
                }
                case 222: {
                    this.sbc(this.readByte());
                    n3 = 8;
                    break;
                }
                case 223: {
                    this.rst(24);
                    n3 = 16;
                    break;
                }
                case 224: {
                    this.mem.write(65280 + this.readByte(), this.AF.getH());
                    n3 = 12;
                    break;
                }
                case 225: {
                    this.pop(this.HL);
                    n3 = 12;
                    break;
                }
                case 226: {
                    this.mem.write(65280 + this.BC.getL(), this.AF.getH());
                    n3 = 8;
                    break;
                }
                case 227: {
                    this.unsupported(227);
                    n3 = 4;
                    break;
                }
                case 228: {
                    this.unsupported(228);
                    n3 = 4;
                    break;
                }
                case 229: {
                    this.push(this.HL);
                    n3 = 16;
                    break;
                }
                case 230: {
                    this.and(this.readByte());
                    n3 = 8;
                    break;
                }
                case 231: {
                    this.rst(32);
                    n3 = 16;
                    break;
                }
                case 232: {
                    this.SP.setR(this.SP.getR() + (byte)this.readByte());
                    this.setZ(false);
                    n3 = 16;
                    break;
                }
                case 233: {
                    this.jp(this.HL.getR());
                    n3 = 4;
                    break;
                }
                case 234: {
                    this.mem.write(this.readWord(), this.AF.getH());
                    n3 = 16;
                    break;
                }
                case 235: {
                    this.unsupported(235);
                    n3 = 4;
                    break;
                }
                case 236: {
                    this.unsupported(236);
                    n3 = 4;
                    break;
                }
                case 237: {
                    this.unsupported(237);
                    n3 = 4;
                    break;
                }
                case 238: {
                    this.xor(this.readByte());
                    n3 = 8;
                    break;
                }
                case 239: {
                    this.rst(40);
                    n3 = 16;
                    break;
                }
                case 240: {
                    this.AF.setH(this.mem.read(65280 + this.readByte()));
                    n3 = 12;
                    break;
                }
                case 241: {
                    this.pop(this.AF);
                    n3 = 12;
                    break;
                }
                case 242: {
                    this.AF.setH(this.mem.read(65280 + this.BC.getL()));
                    n3 = 8;
                    break;
                }
                case 243: {
                    this.di();
                    n3 = 4;
                    break;
                }
                case 244: {
                    this.unsupported(244);
                    n3 = 4;
                    break;
                }
                case 245: {
                    this.push(this.AF);
                    n3 = 16;
                    break;
                }
                case 246: {
                    this.or(this.readByte());
                    n3 = 8;
                    break;
                }
                case 247: {
                    this.rst(48);
                    n3 = 16;
                    break;
                }
                case 248: {
                    this.HL.setR(this.SP.getR() + (byte)this.readByte());
                    n3 = 12;
                    break;
                }
                case 249: {
                    this.SP.setR(this.HL.getR());
                    n3 = 8;
                    break;
                }
                case 250: {
                    this.AF.setH(this.mem.read(this.readWord()));
                    n3 = 16;
                    break;
                }
                case 251: {
                    this.ei();
                    n3 = 4;
                    break;
                }
                case 252: {
                    this.unsupported(252);
                    n3 = 4;
                    break;
                }
                case 253: {
                    this.unsupported(253);
                    n3 = 4;
                    break;
                }
                case 254: {
                    this.cp(this.readByte());
                    n3 = 8;
                    break;
                }
                case 255: {
                    this.rst(56);
                    n3 = 16;
                    break;
                }
                default: {
                    this.unsupported(n2);
                    n3 = 4;
                }
            }
            this.mem.cycle(n3);
            n -= n3;
        }
    }

    private final void interrupt(int n) {
        if ((n & 1) == 1) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFFE);
            this.di();
            this.rst(64);
            return;
        }
        if ((n & 2) == 2) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFFD);
            this.di();
            this.rst(72);
            return;
        }
        if ((n & 4) == 4) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFFB);
            this.di();
            this.rst(80);
            return;
        }
        if ((n & 8) == 8) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFF7);
            this.di();
            this.rst(88);
            return;
        }
        if ((n & 0x10) == 16) {
            this.mem.IF = (byte)(this.mem.IF & 0xFFFFFFEF);
            this.di();
            this.rst(96);
            return;
        }
    }

    private final void di() {
        this.ime = false;
    }

    private final void ei() {
        this.ime = true;
    }

    private final void add(int n) {
        int n2 = this.AF.getH() + n;
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    private final void adc(int n) {
        int n2 = this.AF.getH() + n + (this.getC() ? 1 : 0);
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    private final void sub(int n) {
        int n2 = this.AF.getH() - n;
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(true);
        this.AF.setH(n2);
    }

    private final void sbc(int n) {
        int n2 = this.AF.getH() - n - (this.getC() ? 1 : 0);
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(true);
        this.AF.setH(n2);
    }

    private final void and(int n) {
        int n2 = this.AF.getH() & n;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    private final void or(int n) {
        int n2 = this.AF.getH() | n;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    private final void xor(int n) {
        int n2 = this.AF.getH() ^ n;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.AF.setH(n2);
    }

    private final void cp(int n) {
        this.setC(this.AF.getH() < n);
        this.setZ(this.AF.getH() == n);
        this.setN(true);
    }

    private final void incH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() + 1;
        this.setZ(n &= 0xFF);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void incL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() + 1;
        this.setZ(n &= 0xFF);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void incI(PgbRegister pgbRegister) {
        int n = pgbRegister.getI(this.mem) + 1;
        this.setZ(n &= 0xFF);
        this.setN(false);
        pgbRegister.setI(n, this.mem);
    }

    private final void decH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() - 1;
        this.setZ(n &= 0xFF);
        this.setN(true);
        pgbRegister.setH(n);
    }

    private final void decL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() - 1;
        this.setZ(n &= 0xFF);
        this.setN(true);
        pgbRegister.setL(n);
    }

    private final void decI(PgbRegister pgbRegister) {
        int n = pgbRegister.getI(this.mem) - 1;
        this.setZ(n &= 0xFF);
        this.setN(true);
        pgbRegister.setI(n, this.mem);
    }

    private final void incR(PgbRegister pgbRegister) {
        pgbRegister.setR(pgbRegister.getR() + 1 & 0xFFFF);
    }

    private final void decR(PgbRegister pgbRegister) {
        pgbRegister.setR(pgbRegister.getR() - 1 & 0xFFFF);
    }

    private final void addR(PgbRegister pgbRegister, PgbRegister pgbRegister2) {
        int n = pgbRegister.getR() + pgbRegister2.getR();
        this.setC(n != (n &= 0xFFFF));
        pgbRegister.setR(n);
    }

    private final void pop(PgbRegister pgbRegister) {
        pgbRegister.setL(this.mem.read(this.SP.data++));
        pgbRegister.setH(this.mem.read(this.SP.data++));
    }

    private final void push(PgbRegister pgbRegister) {
        this.mem.write(--this.SP.data & 0xFFFF, pgbRegister.getH());
        this.SP.data &= 0xFFFF;
        this.mem.write(--this.SP.data, pgbRegister.getL());
    }

    private final void jp(int n) {
        this.PC.setR(n);
    }

    private final void jr(int n) {
        this.PC.setR(this.PC.getR() + (byte)n);
    }

    private final void call(int n) {
        this.push(this.PC);
        this.PC.setR(n);
    }

    private final void rst(int n) {
        this.push(this.PC);
        this.PC.setR(n);
    }

    private final void ret() {
        this.pop(this.PC);
    }

    private final void bit(int n, int n2) {
        int n3 = n2 & 1 << n;
        this.setZ(n3);
        this.setN(false);
    }

    private final void resH(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getH() & ~(1 << n);
        pgbRegister.setH(n2);
    }

    private final void resL(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getL() & ~(1 << n);
        pgbRegister.setL(n2);
    }

    private final void resI(int n, int n2) {
        int n3 = this.unsign(this.mem.read(n2)) & ~(1 << n);
        this.mem.write(n2, n3);
    }

    private final void setH(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getH() | 1 << n;
        pgbRegister.setH(n2);
    }

    private final void setL(int n, PgbRegister pgbRegister) {
        int n2 = pgbRegister.getL() | 1 << n;
        pgbRegister.setL(n2);
    }

    private final void setI(int n, int n2) {
        int n3 = this.unsign(this.mem.read(n2)) | 1 << n;
        this.mem.write(n2, n3);
    }

    private final void rrcH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n & 1) == 1);
        n = n >> 1 | (n & 1) << 7;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void rrcL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n & 1) == 1);
        n = n >> 1 | (n & 1) << 7;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void rrcI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 & 1) == 1);
        n2 = n2 >> 1 | (n2 & 1) << 7;
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void rrH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        n = n >> 1 | (this.getC() ? 128 : 0);
        this.setC((pgbRegister.getH() & 1) == 1);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void rrL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        n = n >> 1 | (this.getC() ? 128 : 0);
        this.setC((pgbRegister.getL() & 1) == 1);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void rrI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        n2 = n2 >> 1 | (this.getC() ? 128 : 0);
        this.setC((this.unsign(this.mem.read(n)) & 1) == 1);
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void rlcH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n = n << 1 | n >> 7) != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void rlcL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n = n << 1 | n >> 7) != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void rlcI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 = n2 << 1 | n2 >> 7) != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void rlH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() << 1 | (this.getC() ? 1 : 0);
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void rlL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() << 1 | (this.getC() ? 1 : 0);
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void rlI(int n) {
        int n2 = this.unsign(this.mem.read(n)) << 1 | (this.getC() ? 1 : 0);
        this.setC(n2 != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void sraH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n & 1) == 1);
        n = n >> 1 | n & 0x80;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void sraL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n & 1) == 1);
        n = n >> 1 | n & 0x80;
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void sraI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 & 1) == 1);
        n2 = n2 >> 1 | n2 & 0x80;
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void slaH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() << 1;
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void slaL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() << 1;
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void slaI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 *= 2) != (n2 &= 0xFF));
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void srlH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH();
        this.setC((n & 1) == 1);
        this.setZ(n >>= 1);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void srlL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL();
        this.setC((n & 1) == 1);
        this.setZ(n >>= 1);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void srlI(int n) {
        int n2 = this.unsign(this.mem.read(n));
        this.setC((n2 & 1) == 1);
        this.setZ(n2 >>= 1);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void cpl() {
        int n = ~this.AF.getH() & 0xFF;
        this.setN(true);
        this.AF.setH(n);
    }

    private final void daa() {
        int n = this.AF.getH();
        if (this.getN()) {
            if (n / 16 > 9) {
                n -= 96;
            }
            if ((n & 0xF) > 9) {
                n -= 6;
            }
        } else {
            if (n / 16 > 9) {
                n += 96;
            }
            if ((n & 0xF) > 9) {
                n += 6;
            }
        }
        this.setC(n != (n &= 0xFF));
        this.setZ(n);
        this.AF.setH(n);
    }

    private final void swapH(PgbRegister pgbRegister) {
        int n = pgbRegister.getH() << 4 & 0xF0 | pgbRegister.getH() >> 4;
        this.setC(false);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setH(n);
    }

    private final void swapL(PgbRegister pgbRegister) {
        int n = pgbRegister.getL() << 4 & 0xF0 | pgbRegister.getL() >> 4;
        this.setC(false);
        this.setZ(n);
        this.setN(false);
        pgbRegister.setL(n);
    }

    private final void swapI(int n) {
        int n2 = this.unsign(this.mem.read(n)) << 4 & 0xF0 | this.unsign(this.mem.read(n)) >> 4;
        this.setC(false);
        this.setZ(n2);
        this.setN(false);
        this.mem.write(n, n2);
    }

    private final void setZ(boolean bl) {
        this.AF.lo &= 0xFFFFFF7F;
        if (bl) {
            this.AF.lo |= 0x80;
        }
    }

    private final void setZ(int n) {
        this.AF.lo &= 0xFFFFFF7F;
        if (n == 0) {
            this.AF.lo |= 0x80;
        }
    }

    private final void setN(boolean bl) {
        this.AF.lo &= 0xFFFFFFBF;
        if (bl) {
            this.AF.lo |= 0x40;
        }
    }

    private final void setH(boolean bl) {
        this.AF.lo &= 0xFFFFFFDF;
        if (bl) {
            this.AF.lo |= 0x20;
        }
    }

    private final void setC(boolean bl) {
        this.AF.lo &= 0xFFFFFFEF;
        if (bl) {
            this.AF.lo |= 0x10;
        }
    }

    private final boolean getZ() {
        return (this.AF.getL() & 0x80) == 128;
    }

    private final boolean getN() {
        return (this.AF.getL() & 0x40) == 64;
    }

    private final boolean getH() {
        return (this.AF.getL() & 0x20) == 32;
    }

    private final boolean getC() {
        return (this.AF.getL() & 0x10) == 16;
    }

    private final int readWord() {
        return this.unsign(this.mem.read(this.PC.data++)) | this.unsign(this.mem.read(this.PC.data++)) << 8;
    }

    private final int readByte() {
        return this.unsign(this.mem.read(this.PC.data++));
    }

    private void unsupportedCB(int n) {
        System.out.println("unsupported CB code: " + Integer.toHexString(n));
    }

    private void unsupported(int n) {
        System.out.println(Integer.toHexString(this.PC.data - 1) + " unsupported opcode: " + Integer.toHexString(n));
    }

    private final int unsign(byte by) {
        return by & 0xFF;
    }
}

