/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public abstract class PgbVideo {
    static final int VBLANK_CYCLES = 109;
    static final int HBLANK_CYCLES = 49;
    static final int OAM_CYCLES = 20;
    static final int TRANSFER_CYCLES = 40;
    static final byte STAT_HBLANK = 0;
    static final byte STAT_VBLANK = 1;
    static final byte STAT_OAM = 2;
    static final byte STAT_TRANSFER = 3;
    static final byte INT_LYC = 64;
    static final byte INT_OAM = 32;
    static final byte INT_HBLANK = 16;
    static final byte INT_VBLANK = 8;
    static final byte INT_LYCMODE = 4;
    PgbVideoOutput vidout;
    public int scx;
    public int scy;
    public int ly;
    public int lyc;
    public int wx;
    public int wy;
    public boolean lcd_on;
    public boolean win_on;
    public boolean win_mode;
    public boolean chr_mode;
    public boolean bg_mode;
    public boolean obj_mode;
    public boolean obj_on;
    public boolean bg_on;
    public int win_src;
    public int bg_src;
    public int obj_siz;
    public int chr_src;
    public boolean int_lyc;
    public boolean int_oam;
    public boolean int_hblank;
    public boolean int_vblank;
    public byte stat_mode;
    int cycles;
    int curframe;
    public long framecount;
    byte[] vram = new byte[16384];
    byte[] oam = new byte[160];
    public int bgpal;
    public int objpal0;
    public int objpal1;
    boolean sgbvramon;
    byte[] sgbPicture = new byte[4096];
    byte[] sgbCharset = new byte[16384];
    byte[] sgbPalette = new byte[32];
    byte[] sgbSystemPalette = new byte[4096];
    byte[] sgbAtfData = new byte[6144];
    byte[] sgbPaletteOverlay = new byte[90];
    byte[] gbcPalette = new byte[128];
    byte gbcVram;
    int vramOffset;
    byte bgpi;
    byte obpi;

    public void reset() {
        int n;
        for (n = 0; n < 16384; ++n) {
            this.vram[n] = 0;
        }
        for (n = 0; n < 160; ++n) {
            this.oam[n] = 0;
        }
        this.setLcdc((byte)-111);
        this.setStat((byte)-128);
        this.scy = 0;
        this.scx = 0;
        this.wx = 0;
        this.wy = 0;
        this.ly = 0;
        this.lyc = 0;
        this.cycles = 0;
        this.curframe = 0;
        this.framecount = 0L;
        this.setBgPal(252);
        this.setObjPal0(255);
        this.setObjPal1(255);
        this.sgbvramon = false;
        this.vramOffset = 32768;
        this.gbcVram = 0;
        this.bgpi = 0;
        this.obpi = 0;
    }

    public byte read(int n) {
        if (n >= 32768 && n < 40960) {
            return this.vram[n - this.vramOffset];
        }
        if (n >= 65024 && n < 65184) {
            return this.oam[n - 65024];
        }
        System.out.println("Read from unmapped video memory:" + Integer.toHexString(n));
        return 0;
    }

    public void write(int n, byte by) {
        if (n >= 32768 && n < 40960) {
            this.vram[n - this.vramOffset] = by;
            return;
        }
        if (n >= 65024 && n < 65184) {
            this.oam[n - 65024] = by;
            return;
        }
        System.out.println("Write to unmapped video memory:" + Integer.toHexString(n) + ", " + Integer.toHexString(by));
    }

    public int cyclesLeft() {
        return this.cycles;
    }

    public int cycle(int n, PgbMemory pgbMemory) {
        int n2 = 0;
        this.cycles -= n;
        if (this.cycles <= 0) {
            if (this.stat_mode == 0 || this.stat_mode == 1) {
                if (++this.ly > 256) {
                    this.ly = 0;
                }
                if (this.ly < 144) {
                    this.hblank();
                    this.stat_mode = (byte)2;
                    this.cycles = (int)(20.0 * PgbSettings.clockspeed);
                    n2 = (byte)(n2 | (this.int_hblank ? 2 : 0));
                } else {
                    this.stat_mode = 1;
                    this.cycles = (int)(109.0 * PgbSettings.clockspeed);
                    if (this.ly == 144) {
                        this.vblank();
                        pgbMemory.soundPlay();
                        n2 = (byte)(n2 | (this.int_vblank ? 3 : 1));
                    }
                }
                if (this.ly == this.lyc) {
                    n2 = (byte)(n2 | (this.int_lyc ? 2 : 0));
                }
                return n2;
            }
            if (this.stat_mode == 2) {
                this.stat_mode = (byte)3;
                this.cycles = (int)(40.0 * PgbSettings.clockspeed);
                n2 = (byte)(n2 | (this.int_oam ? 2 : 0));
                return n2;
            }
            if (this.stat_mode == 3) {
                this.stat_mode = 0;
                this.cycles = (int)(49.0 * PgbSettings.clockspeed);
                return n2;
            }
        }
        return 0;
    }

    public void hblank() {
        if (this.lcd_on && this.curframe == 0) {
            this.vidout.hblank(this.ly);
        }
    }

    public void vblank() {
        ++this.framecount;
        --this.curframe;
        if (this.curframe < 0) {
            this.curframe = PgbSettings.frameskip;
            this.vidout.vblank();
        }
    }

    public void setVideoOutput(PgbVideoOutput pgbVideoOutput) {
        this.vidout = pgbVideoOutput;
    }

    public abstract byte[] getScreenMemory();

    public abstract byte getScreenMemory(int var1);

    public abstract byte getScreenRed(byte var1);

    public abstract byte getScreenGreen(byte var1);

    public abstract byte getScreenBlue(byte var1);

    public abstract int getScreenColor(byte var1);

    public void setBgPal(int n) {
        this.bgpal = n;
    }

    public void setObjPal0(int n) {
        this.objpal0 = n;
    }

    public void setObjPal1(int n) {
        this.objpal1 = n;
    }

    public void setLcdc(byte by) {
        boolean bl = this.lcd_on;
        this.lcd_on = (by & 0x80) == 128;
        this.win_mode = (by & 0x40) == 64;
        this.win_on = (by & 0x20) == 32;
        this.chr_mode = (by & 0x10) == 16;
        this.bg_mode = (by & 8) == 8;
        this.obj_mode = (by & 4) == 4;
        this.obj_on = (by & 2) == 2;
        this.bg_on = (by & 1) == 1;
        this.win_src = this.win_mode ? 39936 : 38912;
        this.chr_src = this.chr_mode ? 32768 : 34816;
        this.bg_src = this.bg_mode ? 39936 : 38912;
        int n = this.obj_siz = this.obj_mode ? 16 : 8;
        if (!bl && this.lcd_on) {
            this.ly = 0;
            this.stat_mode = (byte)2;
            this.cycles = 20;
        }
        if (!this.lcd_on) {
            this.ly = 0;
            this.stat_mode = 0;
            this.cycles = 49;
        }
    }

    public byte getLcdc() {
        byte by = 0;
        by = (byte)(by | (this.lcd_on ? 128 : 0));
        by = (byte)(by | (this.win_mode ? 64 : 0));
        by = (byte)(by | (this.win_on ? 32 : 0));
        by = (byte)(by | (this.chr_mode ? 16 : 0));
        by = (byte)(by | (this.bg_mode ? 8 : 0));
        by = (byte)(by | (this.obj_mode ? 4 : 0));
        by = (byte)(by | (this.obj_on ? 2 : 0));
        by = (byte)(by | (this.bg_on ? 1 : 0));
        return by;
    }

    public void setStat(byte by) {
        this.int_lyc = (by & 0x40) == 64;
        this.int_oam = (by & 0x20) == 32;
        this.int_vblank = (by & 0x10) == 16;
        this.int_hblank = (by & 8) == 8;
    }

    public byte getStat() {
        byte by = 0;
        by = (byte)(by | (this.int_lyc ? 64 : 0));
        by = (byte)(by | (this.int_oam ? 32 : 0));
        by = (byte)(by | (this.int_hblank ? 16 : 0));
        by = (byte)(by | (this.int_vblank ? 8 : 0));
        by = (byte)(by | (this.ly == this.lyc ? 4 : 0));
        by = (byte)(by | this.stat_mode);
        return by;
    }

    public void gbcSetVram(byte by) {
        this.gbcVram = by;
        this.vramOffset = (this.gbcVram & 1) != 0 ? 24576 : 32768;
    }

    public byte gbcGetVram() {
        return this.gbcVram;
    }

    public void gbcSetBgpi(byte by) {
        this.bgpi = by;
    }

    public void gbcSetBgpd(byte by) {
        this.gbcPalette[this.bgpi & 0x3F] = by;
        if ((this.bgpi & 0x80) == 128) {
            this.bgpi = (byte)(this.bgpi + 1);
        }
    }

    public void gbcSetObpi(byte by) {
        this.obpi = by;
    }

    public void gbcSetObpd(byte by) {
        this.gbcPalette[(this.obpi & 0x3F) + 64] = by;
        if ((this.obpi & 0x80) == 128) {
            this.obpi = (byte)(this.obpi + 1);
        }
    }

    public byte gbcGetBgpi() {
        return this.bgpi;
    }

    public byte gbcGetBgpd() {
        return this.gbcPalette[this.bgpi & 0x3F];
    }

    public byte gbcGetObpi() {
        return this.obpi;
    }

    public byte gbcGetObpd() {
        return this.gbcPalette[(this.obpi & 0x3F) + 64];
    }

    public void sgbSetPalette(int n, int n2, byte by, byte by2) {
        this.sgbPalette[n * 8 + n2 * 2 + 0] = by2;
        this.sgbPalette[n * 8 + n2 * 2 + 1] = by;
    }

    public void sgbSetPaletteIndirect(int n, int n2, int n3, int n4, int n5) {
        System.arraycopy(this.sgbSystemPalette, n * 8, this.sgbPalette, 0, 8);
        System.arraycopy(this.sgbSystemPalette, n2 * 8, this.sgbPalette, 8, 8);
        System.arraycopy(this.sgbSystemPalette, n3 * 8, this.sgbPalette, 16, 8);
        System.arraycopy(this.sgbSystemPalette, n4 * 8, this.sgbPalette, 24, 8);
        if (n5 != 0) {
            this.sgbSetOverlayFromAtf(n5);
        }
    }

    public void sgbSetPaletteOverlay(int n, int n2) {
        int n3 = n / 4;
        int n4 = (3 - (n & 3)) * 2;
        int n5 = n3;
        this.sgbPaletteOverlay[n5] = (byte)(this.sgbPaletteOverlay[n5] & ~((byte)(3 << n4)));
        int n6 = n3;
        this.sgbPaletteOverlay[n6] = (byte)(this.sgbPaletteOverlay[n6] | (byte)((n2 & 3) << n4));
    }

    public void sgbSetPaletteOverlayByte(int n, byte by) {
        this.sgbPaletteOverlay[n] = by;
    }

    public void sgbPictureTransfer() {
        System.arraycopy(this.vram, 2048, this.sgbPicture, 0, 4096);
    }

    public void sgbCharsetTransfer(boolean bl, boolean bl2) {
        System.arraycopy(this.vram, 2048, this.sgbCharset, bl2 ? 4096 : 0, 4096);
    }

    public void sgbPaletteTransfer() {
        System.arraycopy(this.vram, 2048, this.sgbSystemPalette, 0, 4096);
    }

    public void sgbAtfTransfer() {
        System.arraycopy(this.vram, 2048, this.sgbAtfData, 0, 6144);
        this.sgbSetOverlayFromAtf(1);
    }

    public void sgbSetOverlayFromAtf(int n) {
        System.arraycopy(this.sgbAtfData, (n & 0x3F) * 90, this.sgbPaletteOverlay, 0, 90);
    }

    public void sgbBlockDesignate(byte by, byte by2, byte n, byte by3, byte by4, byte by5) {
        byte by6 = (byte)((by2 & 3) >> 0);
        byte by7 = (byte)((by2 & 0xC) >> 2);
        byte by8 = (byte)((by2 & 0x30) >> 4);
        boolean bl = (by & 1) == 1;
        boolean bl2 = (by & 2) == 2;
        boolean bl3 = (by & 4) == 4;
        for (byte by9 = 0; by9 < 18; ++by9) {
            for (int i = 0; i < 20; ++i) {
                if ((by9 < by3 || by9 > by5) && bl3) {
                    this.sgbSetPaletteOverlay(by9 * 20 + i, by8);
                }
                if (by9 == by3 || by9 == by5) {
                    if (i < n || i > by4) {
                        if (bl3) {
                            this.sgbSetPaletteOverlay(by9 * 20 + i, by8);
                        }
                    } else if (bl2) {
                        this.sgbSetPaletteOverlay(by9 * 20 + i, by7);
                    }
                }
                if (by9 <= by3 || by9 >= by5) continue;
                if (i < n || i > by4) {
                    if (!bl3) continue;
                    this.sgbSetPaletteOverlay(by9 * 20 + i, by8);
                    continue;
                }
                if (i == n || i == by4) {
                    if (!bl2) continue;
                    this.sgbSetPaletteOverlay(by9 * 20 + i, by7);
                    continue;
                }
                if (!bl) continue;
                this.sgbSetPaletteOverlay(by9 * 20 + i, by6);
            }
        }
    }

    public void sgbLineDesignate(byte by) {
        boolean bl;
        int n = by & 0x1F;
        byte by2 = (byte)((by & 0x60) >> 5);
        boolean bl2 = bl = (by & 0x80) == 128;
        if (bl) {
            for (int i = 0; i < 18; ++i) {
                this.sgbSetPaletteOverlay(i * 20 + n, by2);
            }
        } else {
            for (int i = 0; i < 20; ++i) {
                this.sgbSetPaletteOverlay(n * 20 + i, by2);
            }
        }
    }

    public void sgbDivideDesignate(byte by, byte n) {
        boolean bl;
        byte by2 = (byte)((by & 3) >> 0);
        byte by3 = (byte)((by & 0xC) >> 2);
        byte by4 = (byte)((by & 0x30) >> 4);
        boolean bl2 = bl = (by & 0x40) == 64;
        if (bl) {
            for (int i = 0; i < 18; ++i) {
                for (int j = 0; j < 20; ++j) {
                    if (j < n) {
                        this.sgbSetPaletteOverlay(i * 20 + j, by3);
                    }
                    if (j == n) {
                        this.sgbSetPaletteOverlay(i * 20 + j, by2);
                    }
                    if (j <= n) continue;
                    this.sgbSetPaletteOverlay(i * 20 + j, by4);
                }
            }
        } else {
            for (int i = 0; i < 18; ++i) {
                for (int j = 0; j < 20; ++j) {
                    if (i < n) {
                        this.sgbSetPaletteOverlay(i * 20 + j, by3);
                    }
                    if (i == n) {
                        this.sgbSetPaletteOverlay(i * 20 + j, by2);
                    }
                    if (i <= n) continue;
                    this.sgbSetPaletteOverlay(i * 20 + j, by4);
                }
            }
        }
    }

    public void dumpGbcPalette() {
        File file = new File("gbcPalette");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(this.gbcPalette);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            System.out.println("error!");
            System.out.println(exception.getMessage());
        }
    }

    public void dumpSgbPaletteOverlay() {
        File file = new File("sgbPaletteOverlay");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(this.sgbPaletteOverlay);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            System.out.println("error!");
            System.out.println(exception.getMessage());
        }
    }

    public void dumpVram() {
        File file = new File("vram");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(this.vram);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            System.out.println("error!");
            System.out.println(exception.getMessage());
        }
    }
}

