/*
 * Decompiled with CFR 0.152.
 */
class VoluntaryWaveGenerator {
    public static final int CHAN_LEFT = 1;
    public static final int CHAN_RIGHT = 2;
    public static final int CHAN_MONO = 4;
    int totalLength;
    int cyclePos;
    int cycleLength;
    int amplitude;
    int channel;
    int sampleRate;
    int volumeShift;
    byte[] waveform = new byte[32];

    public VoluntaryWaveGenerator(int n, int n2, int n3, int n4, int n5) {
        this.cycleLength = n;
        this.amplitude = n2;
        this.cyclePos = 0;
        this.channel = n4;
        this.sampleRate = n5;
    }

    public VoluntaryWaveGenerator(int n) {
        this.cyclePos = 0;
        this.channel = 3;
        this.cycleLength = 2;
        this.totalLength = 0;
        this.sampleRate = n;
        this.amplitude = 32;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public void setFrequency(int n) {
        float f = (int)(65536.0f / (float)(2048 - n));
        this.cycleLength = (int)(256.0f * (float)this.sampleRate / f);
        if (this.cycleLength == 0) {
            this.cycleLength = 1;
        }
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getLength() {
        return this.totalLength;
    }

    public void setLength(int n) {
        this.totalLength = n == -1 ? -1 : (256 - n) / 4;
    }

    public void setSamplePair(int n, int n2) {
        this.waveform[n * 2] = (byte)((n2 & 0xF0) >> 4);
        this.waveform[n * 2 + 1] = (byte)(n2 & 0xF);
    }

    public void setVolume(int n) {
        switch (n) {
            case 0: {
                this.volumeShift = 5;
                break;
            }
            case 1: {
                this.volumeShift = 0;
                break;
            }
            case 2: {
                this.volumeShift = 1;
                break;
            }
            case 3: {
                this.volumeShift = 2;
            }
        }
    }

    public void play(byte[] byArray, int n, int n2) {
        if (this.totalLength != 0) {
            --this.totalLength;
            for (int i = n2; i < n2 + n; ++i) {
                int n3 = 31 * this.cyclePos / this.cycleLength;
                int n4 = (this.waveform[n3 & 0x1F] & 0xFF) >> this.volumeShift << 1;
                if ((this.channel & 1) != 0) {
                    int n5 = i * 2;
                    byArray[n5] = (byte)(byArray[n5] + n4);
                }
                if ((this.channel & 2) != 0) {
                    int n6 = i * 2 + 1;
                    byArray[n6] = (byte)(byArray[n6] + n4);
                }
                if ((this.channel & 4) != 0) {
                    int n7 = i;
                    byArray[n7] = (byte)(byArray[n7] + n4);
                }
                this.cyclePos = (this.cyclePos + 256) % this.cycleLength;
            }
        }
    }
}

