/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class AEPgb
extends Applet
implements KeyListener,
WindowListener,
ActionListener,
ItemListener,
Runnable {
    public static boolean applet;
    public JFrame frame = new JFrame("AEPgb 0.89.2");
    public Container container = this.frame.getContentPane();
    public Thread cpuThread;
    public PgbMemory mem;
    public PgbCpu cpu;
    public PgbCart cart;
    public PgbVideo video;
    public PgbJoypad joy;
    public PgbNetplay net;
    public PgbVideoOutput vidout;
    public PgbDirectVideoOutput directvidout;
    public String curfile;
    public String curpath;
    public PgbMenuBar menubar;

    public AEPgb() {
        PgbSettings.load();
        this.curfile = "";
        this.curpath = "";
        this.menubar = new PgbMenuBar(this, this);
        this.cart = new PgbCart();
        this.video = new PgbCachedVideo();
        this.joy = new PgbJoypad();
        this.net = new PgbNetplay();
        this.mem = new PgbMemory(this.cart, this.video, this.joy, this.net);
        this.cpu = new PgbCpu(this.mem);
        this.vidout = this.getPgbVideoOutput(this.video);
        this.frame.setMenuBar(this.menubar);
        this.frame.setResizable(false);
        this.frame.addWindowListener(this);
        this.frame.addKeyListener(this);
        this.frame.addKeyListener(this.joy);
    }

    public static void main(String[] stringArray) {
        System.out.println("Pgb (c) 2000-2001 Ben Mazur");
        System.out.println("AEPgb Version 0.89.2 (c) 2004 retroK, XTale, baka0815");
        AEPgb aEPgb = new AEPgb();
        aEPgb.parseCommandLine(stringArray);
        aEPgb.go();
    }

    public void start() {
        applet = true;
        Thread thread = new Thread(this);
        this.addKeyListener(this);
        System.out.println("AEPgb Version 0.89.2 (c) 2004 retroK & XTale(applet)");
        this.requestFocus();
        this.vidout = this.getPgbVideoOutput(this.video);
        this.cpuThread = new Thread(this);
        this.vidout.setGraphics();
        PgbSettings.paused = true;
        PgbSettings.active = true;
        this.cart.loadApplet("file.gb", this);
        if (this.cart.loaded()) {
            this.reset();
            this.unpause();
        }
        System.out.println("starting cputhread");
        thread.start();
        this.cpuThread.start();
    }

    public void go() {
        this.cpuThread = new Thread(this);
        this.conformToSettings();
        this.frame.pack();
        this.vidout.setGraphics();
        this.frame.setVisible(true);
        PgbSettings.paused = true;
        PgbSettings.active = true;
        this.cart.load(this.curpath, this.curfile);
        if (this.cart.loaded()) {
            this.setSystem(PgbSettings.desiredsystem);
            PgbSettings.gamestring = this.cart.getName();
            this.reset();
            this.unpause();
        }
        this.cpuThread.start();
    }

    public void shutdown() {
        this.cpuThread = null;
        PgbSettings.save(this.frame);
        this.cart.saveBattery(PgbSettings.savepath, this.curfile);
        System.exit(0);
    }

    public synchronized void pause() {
        if (!PgbSettings.paused) {
            PgbSettings.paused = true;
        }
        this.menubar.cpu_paused.setState(PgbSettings.paused);
    }

    public synchronized void unpause() {
        if (PgbSettings.paused) {
            PgbSettings.paused = false;
            this.notifyAll();
        }
        this.menubar.cpu_paused.setState(PgbSettings.paused);
    }

    public synchronized void reset() {
        this.pause();
        this.video.reset();
        this.vidout.reset();
        this.cart.reset();
        this.joy.reset();
        this.mem.reset();
        this.cpu.reset();
        this.unpause();
    }

    public void parseCommandLine(String[] stringArray) {
        if (stringArray.length > 0) {
            this.curfile = stringArray[stringArray.length - 1];
        }
    }

    public PgbVideoOutput getPgbVideoOutput(PgbVideo pgbVideo) {
        if (applet) {
            return new PgbDirectVideoOutput(pgbVideo, this);
        }
        if (PgbSettings.videooutput == 1 && !PgbSettings.usedirectx) {
            PgbSettings.videooutput = 0;
        }
        switch (PgbSettings.videooutput) {
            case 0: {
                return new PgbIndexedVideoOutput(pgbVideo);
            }
            case 3: {
                return new PgbDirectVideoOutput(pgbVideo);
            }
        }
        return new PgbIndexedVideoOutput(pgbVideo);
    }

    public void conformToSettings() {
        this.setSgbBorder(PgbSettings.sgbborder);
        this.setColorMute(PgbSettings.colormute);
        this.frame.setLocation(PgbSettings.winloc);
        this.setDebugLevel(PgbSettings.debuglevel);
        this.setFrameskip(PgbSettings.frameskip);
        this.setPriority(PgbSettings.priority);
        this.setVideoOutput(PgbSettings.videooutput);
        this.setSystem(PgbSettings.desiredsystem);
        this.setLcdSize(PgbSettings.lcdsize);
    }

    void setPriority(int n) {
        PgbSettings.priority = n;
        this.menubar.priority_low.setState(n == 1);
        this.menubar.priority_normal.setState(n == 5);
        this.menubar.priority_high.setState(n == 7);
        this.menubar.priority_max.setState(n == 10);
        this.cpuThread.setPriority(n);
    }

    void setSound(boolean bl) {
        PgbSettings.usesound = bl;
        this.menubar.sound.setState(bl);
        this.mem.soundChip.channel1Enable = this.menubar.sound.getState();
        this.menubar.soundChannel1Enable.setState(this.menubar.sound.getState());
        this.mem.soundChip.channel2Enable = this.menubar.sound.getState();
        this.menubar.soundChannel2Enable.setState(this.menubar.sound.getState());
        this.mem.soundChip.channel3Enable = this.menubar.sound.getState();
        this.menubar.soundChannel3Enable.setState(this.menubar.sound.getState());
        this.mem.soundChip.channel4Enable = this.menubar.sound.getState();
        this.menubar.soundChannel4Enable.setState(this.menubar.sound.getState());
    }

    void setChannelEnable() {
        if (this.menubar.soundChannel1Enable.getState() || this.menubar.soundChannel2Enable.getState() || this.menubar.soundChannel3Enable.getState() || this.menubar.soundChannel4Enable.getState()) {
            this.menubar.sound.setState(true);
        }
        this.mem.soundChip.channel1Enable = this.menubar.soundChannel1Enable.getState();
        this.mem.soundChip.channel2Enable = this.menubar.soundChannel2Enable.getState();
        this.mem.soundChip.channel3Enable = this.menubar.soundChannel3Enable.getState();
        this.mem.soundChip.channel4Enable = this.menubar.soundChannel4Enable.getState();
    }

    void setSoundFreq(int n) {
        if (n == 11025) {
            this.menubar.soundFreq11.setState(true);
            this.menubar.soundFreq22.setState(false);
            this.menubar.soundFreq44.setState(false);
        }
        if (n == 22050) {
            this.menubar.soundFreq22.setState(true);
            this.menubar.soundFreq11.setState(false);
            this.menubar.soundFreq44.setState(false);
        }
        if (n == 44100) {
            this.menubar.soundFreq44.setState(true);
            this.menubar.soundFreq11.setState(false);
            this.menubar.soundFreq22.setState(false);
        }
        this.mem.soundChip.setSampleRate(n);
    }

    void setBufferLength(int n) {
        if (n == 200) {
            this.menubar.soundBuffer200.setState(true);
            this.menubar.soundBuffer300.setState(false);
            this.menubar.soundBuffer400.setState(false);
        }
        if (n == 300) {
            this.menubar.soundBuffer300.setState(true);
            this.menubar.soundBuffer200.setState(false);
            this.menubar.soundBuffer400.setState(false);
        }
        if (n == 400) {
            this.menubar.soundBuffer400.setState(true);
            this.menubar.soundBuffer200.setState(false);
            this.menubar.soundBuffer300.setState(false);
        }
        this.mem.soundChip.setBufferLength(n);
    }

    void setLcdSize(int n) {
        PgbSettings.lcdsize = n;
        this.menubar.size_1.setState(n == 1);
        this.menubar.size_2.setState(n == 2);
        this.menubar.size_3.setState(n == 3);
        this.menubar.size_4.setState(n == 4);
        Dimension dimension = PgbSettings.sgbborder ? new Dimension(256 * n, 224 * n) : new Dimension(160 * n, 144 * n);
        this.vidout.setSize(dimension);
        this.frame.setSize(this.frame.getInsets().right + dimension.width + this.frame.getInsets().left, this.frame.getInsets().top + dimension.height + this.frame.getInsets().bottom);
    }

    void setVideoOutput(int n) {
        if (n == 1 && !PgbSettings.usedirectx) {
            n = 0;
        }
        PgbSettings.videooutput = n;
        if (n == 0) {
            this.menubar.vidout_default.setState(true);
            if (PgbSettings.usedirectx) {
                this.menubar.vidout_directx.setState(true);
                this.menubar.vidout_indexed.setState(false);
                this.menubar.vidout_direct.setState(false);
            } else {
                this.menubar.vidout_directx.setState(false);
                this.menubar.vidout_indexed.setState(true);
                this.menubar.vidout_direct.setState(false);
            }
        } else {
            this.menubar.vidout_default.setState(n == 0);
            this.menubar.vidout_directx.setState(n == 1);
            this.menubar.vidout_indexed.setState(n == 2);
            this.menubar.vidout_direct.setState(n == 3);
        }
        this.pause();
        PgbVideoOutput pgbVideoOutput = this.vidout;
        PgbVideoOutput pgbVideoOutput2 = this.getPgbVideoOutput(this.video);
        pgbVideoOutput2.addKeyListener(this);
        pgbVideoOutput2.addKeyListener(this.joy);
        this.frame.remove(pgbVideoOutput);
        this.frame.getContentPane().add(pgbVideoOutput2);
        this.frame.validate();
        if (this.frame.isVisible()) {
            pgbVideoOutput2.reset();
            pgbVideoOutput2.requestFocus();
        }
        this.vidout = pgbVideoOutput2;
        this.unpause();
    }

    void setColorMute(boolean bl) {
        PgbSettings.colormute = bl;
        this.menubar.color_mute.setState(bl);
    }

    void setSgbBorder(boolean bl) {
        PgbSettings.sgbborder = bl;
        this.menubar.sgb_border.setState(bl);
    }

    void setFrameskip(int n) {
        PgbSettings.frameskip = n;
        this.menubar.auto_wait.setState(PgbSettings.autowait);
        this.menubar.fs_0.setState(n == 0);
        this.menubar.fs_1.setState(n == 1);
        this.menubar.fs_2.setState(n == 2);
        this.menubar.fs_3.setState(n == 3);
        this.menubar.fs_4.setState(n == 4);
        this.menubar.fs_5.setState(n == 5);
    }

    void setDebugLevel(int n) {
        PgbSettings.debuglevel = n;
        this.menubar.debug_0.setState(n == 0);
        this.menubar.debug_1.setState(n == 1);
        this.menubar.debug_2.setState(n == 2);
        this.menubar.debug_3.setState(n == 3);
        this.menubar.debug_4.setState(n == 4);
        this.menubar.debug_5.setState(n == 5);
    }

    void setSystem(int n) {
        PgbSettings.desiredsystem = n;
        this.menubar.sys_gb.setState(n == 0);
        this.menubar.sys_gbp.setState(n == 1);
        this.menubar.sys_sgb.setState(n == 10);
        this.menubar.sys_gbc.setState(n == 11);
        if (n == 11 && !this.cart.getGbc()) {
            n = 10;
        }
        if (n == 10 && !this.cart.getSgb()) {
            n = 1;
        }
        PgbSettings.system = n;
    }

    synchronized void loadCart() {
        this.cart.saveBattery(PgbSettings.savepath, this.curfile);
        FileDialog fileDialog = new FileDialog((Frame)this.frame, this.curpath, 0);
        fileDialog.setTitle("Load ROM...");
        fileDialog.setFilenameFilter(this.cart);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        this.curfile = fileDialog.getFile();
        this.curpath = fileDialog.getDirectory();
        if (this.cart.load(this.curpath, this.curfile)) {
            this.setSystem(PgbSettings.desiredsystem);
            PgbSettings.gamestring = this.cart.getName();
            this.net.sendInfo();
            this.reset();
            this.unpause();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.shutdown();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public synchronized void windowDeiconified(WindowEvent windowEvent) {
        if (!PgbSettings.active) {
            PgbSettings.active = true;
            this.notifyAll();
        }
    }

    public synchronized void windowActivated(WindowEvent windowEvent) {
    }

    public synchronized void windowIconified(WindowEvent windowEvent) {
        if (PgbSettings.active) {
            PgbSettings.active = false;
        }
    }

    public synchronized void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.cpu.exec(1);
        }
        if (keyEvent.getKeyCode() == PgbSettings.key_screen) {
            this.vidout.makeScreenshot();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("file_about")) {
            String string = "Pgb (c) 2000-2001 Ben Mazur\nAEPgb Version 0.89.2 (c) 2004 retroK, XTale, baka0815\nhttp://aepgb.aep-emu.de/";
            JOptionPane.showMessageDialog(this.frame, string, "About AEPgb", 1);
            return;
        }
        if (actionEvent.getActionCommand().equals("file_load")) {
            this.loadCart();
            return;
        }
        if (actionEvent.getActionCommand().equals("file_exit")) {
            this.shutdown();
            return;
        }
        if (actionEvent.getActionCommand().equals("cpu_reset")) {
            this.reset();
            return;
        }
        if (actionEvent.getActionCommand().equals("cpu_paused")) {
            if (PgbSettings.paused) {
                this.unpause();
            } else {
                this.pause();
            }
            return;
        }
        if (actionEvent.getActionCommand().equals("serial_connect")) {
            this.net.popNetDialog(this.frame);
            return;
        }
        if (actionEvent.getActionCommand().equals("options_setkeys")) {
            PgbSettings.popKeysDialog(this.frame);
            return;
        }
        if (actionEvent.getActionCommand().equals("options_setsavepath")) {
            PgbSettings.popSavePathDialog(this.frame);
            return;
        }
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable().equals(this.menubar.cpu_paused)) {
            if (PgbSettings.paused) {
                this.unpause();
            } else {
                this.pause();
            }
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.vidout_default)) {
            this.setVideoOutput(0);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.vidout_directx)) {
            this.setVideoOutput(1);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.vidout_indexed)) {
            this.setVideoOutput(2);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.vidout_direct)) {
            this.setVideoOutput(3);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.sound)) {
            this.setSound(this.menubar.sound.getState());
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.soundChannel1Enable) || itemEvent.getItemSelectable().equals(this.menubar.soundChannel2Enable) || itemEvent.getItemSelectable().equals(this.menubar.soundChannel3Enable) || itemEvent.getItemSelectable().equals(this.menubar.soundChannel4Enable)) {
            this.setChannelEnable();
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.soundBuffer200)) {
            this.setBufferLength(200);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.soundBuffer300)) {
            this.setBufferLength(300);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.soundBuffer400)) {
            this.setBufferLength(400);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.soundFreq11)) {
            this.setSoundFreq(11025);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.soundFreq22)) {
            this.setSoundFreq(22050);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.soundFreq44)) {
            this.setSoundFreq(44100);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.size_1)) {
            this.setLcdSize(1);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.size_2)) {
            this.setLcdSize(2);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.size_3)) {
            this.setLcdSize(3);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.size_4)) {
            this.setLcdSize(4);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.color_mute)) {
            this.setColorMute(this.menubar.color_mute.getState());
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.sgb_border)) {
            this.setSgbBorder(this.menubar.sgb_border.getState());
            this.setLcdSize(PgbSettings.lcdsize);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.auto_wait)) {
            PgbSettings.autowait = !PgbSettings.autowait;
            this.setFrameskip(PgbSettings.frameskip);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.fs_0)) {
            this.setFrameskip(0);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.fs_1)) {
            this.setFrameskip(1);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.fs_2)) {
            this.setFrameskip(2);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.fs_3)) {
            this.setFrameskip(3);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.fs_4)) {
            this.setFrameskip(4);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.fs_5)) {
            this.setFrameskip(5);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.priority_low)) {
            this.setPriority(1);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.priority_normal)) {
            this.setPriority(5);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.priority_high)) {
            this.setPriority(7);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.priority_max)) {
            this.setPriority(10);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.debug_0)) {
            this.setDebugLevel(0);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.debug_1)) {
            this.setDebugLevel(1);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.debug_2)) {
            this.setDebugLevel(2);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.debug_3)) {
            this.setDebugLevel(3);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.debug_4)) {
            this.setDebugLevel(4);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.debug_5)) {
            this.setDebugLevel(5);
            return;
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.sys_gb)) {
            this.setSystem(0);
            this.reset();
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.sys_gbp)) {
            this.setSystem(1);
            this.reset();
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.sys_sgb)) {
            this.setSystem(10);
            this.reset();
        }
        if (itemEvent.getItemSelectable().equals(this.menubar.sys_gbc)) {
            this.setSystem(11);
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = this.video.framecount;
        long l3 = 1L;
        Thread thread = Thread.currentThread();
        while (this.cpuThread == thread) {
            try {
                Thread.sleep(l3);
                AEPgb aEPgb = this;
                synchronized (aEPgb) {
                    while ((PgbSettings.paused || !PgbSettings.active) && this.cpuThread == thread) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.cpu.exec((int)(PgbSettings.clockspeed * 100000.0));
            if (n++ != 10) continue;
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = this.video.framecount - l2;
            int n2 = (int)((double)l6 * (1000.0 / (double)l5));
            int n3 = 60;
            if (PgbSettings.autowait) {
                if (n3 - n2 > 5) {
                    l3 = Math.max(l3 - 4L, 1L);
                }
                if (n2 - n3 > 5) {
                    l3 += 4L;
                }
            } else {
                l3 = 1L;
            }
            this.frame.setTitle("AEPgb : " + n2 + "/" + n3 + " fps, wait=" + l3);
            n = 0;
            l = l4;
            l2 = this.video.framecount;
        }
    }
}

