/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class PgbNetplay
implements ActionListener {
    boolean connected;
    Socket socket;
    PgbConnectionStatus pcs;
    byte serialData;
    byte serialControl;
    byte lastSerialData;
    boolean newSerialData;
    boolean waitingOnSerial;
    int serialCount;
    int serialRetryCount;
    boolean irTransmit;
    boolean irReceive;
    boolean irReadOn;

    public void PgbNetPlay() {
        this.socket = null;
        this.connected = false;
        this.serialCount = 0;
        this.serialControl = 0;
        this.irReadOn = false;
    }

    public int cyclesLeft() {
        if (!this.waitingOnSerial) {
            return Integer.MAX_VALUE;
        }
        return this.serialCount;
    }

    public byte cycle(int n) {
        if (this.waitingOnSerial) {
            this.serialCount -= n;
            if (this.serialCount <= 0) {
                this.doInput();
                if (this.newSerialData) {
                    this.serialData = this.lastSerialData;
                    this.newSerialData = false;
                    this.serialControl = 0;
                    this.waitingOnSerial = false;
                    if (this.connected) {
                        this.pcs.setStatus("read serial: " + this.serialData);
                    }
                    return 8;
                }
                if (this.serialRetryCount-- > 0) {
                    this.serialCount = 19520;
                } else {
                    this.serialData = this.lastSerialData;
                    this.newSerialData = false;
                    this.serialControl = 0;
                    this.waitingOnSerial = false;
                    if (this.connected) {
                        this.pcs.setStatus("read serial: " + this.serialData);
                    }
                    return 8;
                }
            }
        }
        return 0;
    }

    public void setSerialData(byte by) {
        this.serialData = by;
    }

    public byte getSerialData() {
        return this.serialData;
    }

    public void setSerialControl(byte by) {
        this.serialControl = by;
        if ((this.serialControl & 0x80) == 128) {
            if ((this.serialControl & 1) == 1 || this.connected) {
                this.waitingOnSerial = true;
                this.serialCount = 3904;
                this.serialRetryCount = 2;
            } else {
                this.waitingOnSerial = false;
            }
            if (this.connected) {
                try {
                    this.socket.setTcpNoDelay(true);
                    OutputStream outputStream = this.socket.getOutputStream();
                    outputStream.write(3);
                    outputStream.write(this.serialData & 0xFF);
                    this.pcs.setStatus("wrote serial: " + this.serialData);
                }
                catch (IOException iOException) {}
            }
        } else {
            this.waitingOnSerial = false;
        }
    }

    public byte getSerialControl() {
        return this.serialControl;
    }

    public void setIR(byte by) {
        this.irTransmit = (by & 1) == 1;
        boolean bl = this.irReadOn = (by & 0xC0) == 192;
        if (this.connected) {
            try {
                this.socket.setTcpNoDelay(true);
                OutputStream outputStream = this.socket.getOutputStream();
                outputStream.write(2);
                outputStream.write(this.irTransmit ? 1 : 0);
                this.pcs.setStatus("wrote I/R: " + this.irTransmit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte getIR() {
        if (this.irReadOn) {
            this.doInput();
        }
        return this.irReceive ? (byte)-62 : -64;
    }

    public void doInput() {
        if (this.connected) {
            try {
                this.socket.setTcpNoDelay(true);
                this.socket.setSoTimeout(1);
                InputStream inputStream = this.socket.getInputStream();
                while (true) {
                    int n = inputStream.read();
                    switch (n) {
                        case 16: {
                            int n2 = inputStream.read();
                            byte[] byArray = new byte[n2];
                            inputStream.read(byArray);
                            this.pcs.setGame(new String(byArray));
                            break;
                        }
                        case 17: {
                            int n2 = inputStream.read();
                            byte[] byArray = new byte[n2];
                            inputStream.read(byArray);
                            this.pcs.setGame(new String(byArray));
                            break;
                        }
                        case 18: {
                            int n2 = inputStream.read();
                            byte[] byArray = new byte[n2];
                            inputStream.read(byArray);
                            this.pcs.setGame(new String(byArray));
                            break;
                        }
                        case 2: {
                            this.irReceive = inputStream.read() != 0;
                            this.pcs.setStatus("read I/R: " + this.irReceive);
                            break;
                        }
                        case 3: {
                            this.lastSerialData = (byte)inputStream.read();
                            this.newSerialData = true;
                        }
                    }
                }
            }
            catch (IOException iOException) {}
        } else {
            this.lastSerialData = (byte)-1;
            this.newSerialData = true;
        }
    }

    public void sendInfo() {
        if (this.connected) {
            try {
                this.socket.setTcpNoDelay(true);
                OutputStream outputStream = this.socket.getOutputStream();
                outputStream.write(16);
                outputStream.write(PgbSettings.gamestring.length());
                outputStream.write(PgbSettings.gamestring.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void popNetDialog(Frame frame) {
        PgbNetDialog pgbNetDialog = new PgbNetDialog(frame);
        pgbNetDialog.setLocation(frame.getLocation().x - 60, frame.getLocation().y + 80);
        pgbNetDialog.setVisible(true);
        if (pgbNetDialog.socket == null) {
            this.connected = false;
            return;
        }
        this.socket = pgbNetDialog.socket;
        this.connected = true;
        this.pcs = new PgbConnectionStatus(frame, this, this.socket);
        this.pcs.setLocation(frame.getLocation().x - 310, frame.getLocation().y);
        this.pcs.setVisible(true);
    }

    public void disconnect() {
        if (this.connected) {
            this.connected = false;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pcs.setVisible(false);
            this.pcs.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("disconnect")) {
            this.disconnect();
        }
        if (actionEvent.getActionCommand().equals("close")) {
            this.pcs.setVisible(false);
            this.pcs.dispose();
        }
    }
}

