/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

class SoundChip {
    SourceDataLine soundLine = this.initSoundHardware();
    SquareWaveGenerator channel1 = new SquareWaveGenerator(this.sampleRate);
    SquareWaveGenerator channel2 = new SquareWaveGenerator(this.sampleRate);
    VoluntaryWaveGenerator channel3 = new VoluntaryWaveGenerator(this.sampleRate);
    NoiseGenerator channel4 = new NoiseGenerator(this.sampleRate);
    boolean soundEnabled = false;
    boolean channel1Enable = true;
    boolean channel2Enable = true;
    boolean channel3Enable = true;
    boolean channel4Enable = true;
    int sampleRate = 44100;
    int bufferLengthMsec = 200;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public SourceDataLine initSoundHardware() {
        try {
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 8, 2, 2, this.sampleRate, true);
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SoundChip.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
            if (AudioSystem.isLineSupported(info)) {
                SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                int n = this.sampleRate / 1000 * this.bufferLengthMsec;
                sourceDataLine.open(audioFormat, n);
                sourceDataLine.start();
                this.soundEnabled = true;
                return sourceDataLine;
            }
            System.out.println("Error: Can't find audio output system!");
            this.soundEnabled = false;
        }
        catch (Exception exception) {
            System.out.println("Error: Audio system busy!");
            this.soundEnabled = false;
        }
        return null;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
        this.soundLine.flush();
        this.soundLine.close();
        this.soundLine = this.initSoundHardware();
        this.channel1.setSampleRate(n);
        this.channel2.setSampleRate(n);
        this.channel3.setSampleRate(n);
        this.channel4.setSampleRate(n);
    }

    public void setBufferLength(int n) {
        this.bufferLengthMsec = n;
        this.soundLine.flush();
        this.soundLine.close();
        this.soundLine = this.initSoundHardware();
    }

    public void outputSound() {
        if (this.soundEnabled) {
            int n = this.sampleRate / 28 >= this.soundLine.available() * 2 ? this.soundLine.available() * 2 : this.sampleRate / 28 & 0xFFFE;
            byte[] byArray = new byte[n];
            if (this.channel1Enable) {
                this.channel1.play(byArray, n / 2, 0);
            }
            if (this.channel2Enable) {
                this.channel2.play(byArray, n / 2, 0);
            }
            if (this.channel3Enable) {
                this.channel3.play(byArray, n / 2, 0);
            }
            if (this.channel4Enable) {
                this.channel4.play(byArray, n / 2, 0);
            }
            this.soundLine.write(byArray, 0, n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

