
#include <stdlib.h>
#include "config.h"
#include "fileio.h"

#define CONFIG_VERSION	2

config_t config;

void init_config()
{
	// initial settings
	config.version = CONFIG_VERSION;
	
	for(int i = 0; i < 8; i++) {
		for(int j = 0; j < 4; j++)
			_tcscpy(config.recent_disk[j][i], _T(""));
		_tcscpy(config.recent_tape[i], _T(""));
	}
	config.cpu_clock = 0;
	config.m1_cycle = false;
	
	config.fast_timer = false;
	
	config.joy_type = 0;
	
	config.monitor_type = 0;
	config.scan_line = false;
	config.super_impose = false;
	
	config.patch_fdc1 = false;
	config.patch_fdc2 = false;
	config.patch_mouse = false;
	
#ifdef _WIN32_WCE
	config.skip_frames = 0;
#else
	config.skip_frames = 1;
#endif
	
#ifdef _WIN32_WCE
	config.sound_enable = false;
#else
	config.sound_enable = true;
#endif
	config.sound_frequency = 1;
	config.sound_latency = 1;
}

void load_config()
{
	// initial settings
	init_config();
	
	// get config path
	_TCHAR app_path[_MAX_PATH], config_path[_MAX_PATH];
	GetModuleFileName(NULL, app_path, _MAX_PATH);
	int pt = _tcslen(app_path);
	while(app_path[pt] != '\\')
		pt--;
	app_path[pt + 1] = '\0';
#ifdef _WIN32_HPC
	_stprintf(config_path, _T("%smz2500hpc.cfg"), app_path);
#elif defined _WIN32_PPC
	_stprintf(config_path, _T("%smz2500ppc.cfg"), app_path);
#elif defined _WIN32_SIG
	_stprintf(config_path, _T("%smz2500sig3.cfg"), app_path);
#else
	_stprintf(config_path, _T("%smz2500.cfg"), app_path);
#endif
	
	// load config
	FILEIO* fio = new FILEIO();
	if(fio->Fopen(config_path, FILEIO_READ_BINARY)) {
		fio->Fread((void *)&config, sizeof(config), 1);
		fio->Fclose();
	}
	delete fio;
	
	// check id
	if(config.version != CONFIG_VERSION)
		init_config();

#ifdef _WIN32_PPC
	config.sound_enable = false;
	config.sound_frequency = 1;
	config.sound_latency = 1;
#endif
}

void save_config()
{
	// get config path
	_TCHAR app_path[_MAX_PATH], config_path[_MAX_PATH];
	GetModuleFileName(NULL, app_path, _MAX_PATH);
	int pt = _tcslen(app_path);
	while(app_path[pt] != '\\')
		pt--;
	app_path[pt + 1] = '\0';
#ifdef _WIN32_HPC
	_stprintf(config_path, _T("%smz2500hpc.cfg"), app_path);
#elif defined _WIN32_PPC
	_stprintf(config_path, _T("%smz2500ppc.cfg"), app_path);
#elif defined _WIN32_SIG
	_stprintf(config_path, _T("%smz2500sig3.cfg"), app_path);
#else
	_stprintf(config_path, _T("%smz2500.cfg"), app_path);
#endif
	
	// save config
	FILEIO* fio = new FILEIO();
	if(fio->Fopen(config_path, FILEIO_WRITE_BINARY)) {
		fio->Fwrite((void *)&config, sizeof(config), 1);
		fio->Fclose();
	}
	delete fio;
}

