/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ cassette (i8255) ]
*/

#ifndef _CASSETTE_H_
#define _CASSETTE_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class CASSETTE : public DEVICE
{
private:
	void write_porta(uint8 data);
	void write_portb(uint8 data);
	void write_portc(uint8 data);
	
	uint8 areg, breg, creg;
	uint8 vector;
	
	// play sound tape
	void play_media();
	void stop_media();
	
	int regist_pre, regist_signal, regist_after;
	
	int fw_rw_mode;
	bool now_signal, now_playing;
	float track;
	
	// ext signal
	uint8 key_stat;
	bool vblank;
	
public:
	CASSETTE(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~CASSETTE() {}
	
	// common functions
	void initialize();
	void release();
	void reset();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[5] = { 0xe0, 0xe1, 0xe2, 0xe3, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[5] = { 0xe0, 0xe1, 0xe2, 0xe3, -1 };
		return map[index];
	}
	
	void write_signal(int ch, uint32 data);
	void event_callback(int event_id, int err);
};

#endif

