/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.30 -

	[ crtc ]
*/

#ifndef _CRTC_H_
#define _CRTC_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

#ifdef _WIN32_WCE
// RGB565
#define RGB_COLOR(r, g, b) (uint16)(((uint16)(r) << 11) | ((uint16)(g) << 6) | (uint16)(b))
#else
// RGB555
#define RGB_COLOR(r, g, b) (uint16)(((uint16)(r) << 10) | ((uint16)(g) << 5) | (uint16)(b))
#endif

#ifdef _WIN32_HPC
//#define OPTIMIZE_TEXT
#endif

#define SCRN_640x400	1
#define SCRN_640x200	2
#define SCRN_320x200	3

class CRTC : public DEVICE
{
private:
	// config
	bool scan_line, scan_tmp;
	bool monitor_200line;
	bool monitor_digital, monitor_tmp;
	
	// vram
	uint8 *vram_b, *vram_r, *vram_g, *vram_i;
	uint8 *tvram1, *attrib, *tvram2;
	// kanji rom, pcg
	uint8 *kanji1, *kanji2;
	uint8 *pcg0, *pcg1, *pcg2, *pcg3;
	
	// crtc
	uint8 textreg_num, textreg[32];
	uint8 cgreg_num, cgreg[32];
	uint8 scrn_size, cg_mask;
	bool font_size, column_size;
	uint8 latch[4];
	uint16 GDEVS, GDEVE;
	uint8 GDEHS, GDEHE;
	bool hblank, vblank, blink;
	uint8 clear_flag;
	uint8 vector;
	
	// palette, priority
	uint16 palette16[16+8], palette256[256+16+64], palette4096[16];
	uint8 palette4096r[16], palette4096g[16], palette4096b[16];
	uint8 palette_reg[16];
	uint8 priority[16][9];
	uint16 priority256[256][16+64];
	
	bool pal_select;
	
	// draw text
	void draw_text();
	void draw_80column_screen();
	void draw_40column_screen();
	void draw_80column_font(uint16 src, int dest, int y);
	void draw_40column_font(uint16 src, int dest, int y);
	
	uint8 text[640*480*2];
	
	// draw cg
	void draw_cg();
	void draw_320x200x16screen(uint8 pl);
	void draw_320x200x256screen(uint8 pl);
	void draw_640x200x16screen(uint8 pl);
	void draw_640x400x4screen();
	void draw_640x400x16screen();
	void create_320x200map();
	void create_640x200map();
	void create_640x400map();
	
	uint8 cg[640*400*2];
	uint16 map_addr[400][80];
	uint8 map_hdsc[400][80];
	
	// speed optimize
	uint8 cg_matrix0[256][256][8];
	uint8 cg_matrix1[256][256][8];
	uint8 cg_matrix2[256][256][8];
	uint8 cg_matrix3[256][256][8];
	uint8 text_matrix[256][9][8];
	uint8 text_matrixw[256][9][16];
	uint8 trans_color;
	bool map_init, trans_init;
	
#ifdef OPTIMIZE_TEXT
	uint8 tvram1_cmp[0x800];
	uint8 tvram2_cmp[0x800];
	uint8 attrib_cmp[0x800];
	bool text_init;
#endif
	
public:
	CRTC(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~CRTC() {}
	
	// common functions
	void initialize();
	void update_config();
	void reset();
	
	void write_data8(uint16 addr, uint8 data);
	uint8 read_data8(uint16 addr);
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[8] = { 0xae, 0xbc, 0xbd, 0xf4, 0xf5, 0xf6, 0xf7, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[9] = { 0xbc, 0xbd, 0xbe, 0xbf, 0xf4, 0xf5, 0xf6, 0xf7, -1 };
		return map[index];
	}
	
	void write_signal(int ch, uint32 data);
	void event_callback(int event_id, int err);
	
	// unique function
	void write_vector(uint8 data) { vector = data; }
	void set_hsync(int cnt);
	void set_vsync(int cnt);
	void draw_screen();
};

#endif

