/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ emm ]
*/

#ifndef _EMM_H_
#define _EMM_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class EMM : public DEVICE
{
private:
	uint8* buf;
	uint32 ptr, size;
public:
	EMM(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~EMM() {}
	
	// common functions
	void initialize();
	void release();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[3] = { 0xac, 0xad, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[2] = { 0xad, -1 };
		return map[index];
	}
};

#endif

