/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ ext rom (MZ-1R12) ]
*/

#ifndef _EXTROM_H_
#define _EXTROM_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class EXTROM : public DEVICE
{
private:
	uint8 buf[0x10000];
	uint16 ptr;
public:
	EXTROM(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~EXTROM() {}
	
	// common functions
	void initialize();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[3] = { 0xf8, 0xf9, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[2] = { 0xf8, -1 };
		return map[index];
	}
};

#endif

