/*
	MZ-2500 Emulator 'EmuZ-2500'

	Author : Takeda.Toshiya
	Date   : 2003.11.28 -

	[ FM ]
*/

#ifndef _OPN_H_ 
#define _OPN_H_

#include "../../common.h"

class OPN
{
private:
	uint16 f_number[6];
	uint16 volume[6];
	uint8 octove[6];
	double frq[6];
	double interval[6];
	double counter[6];
	bool pulse[6];
	bool keyon[6];
	uint8 ssg_pre;
	uint8 opn_pre;
	uint8 regs[0x10];
	int rate;
public:
	void Init(int clock, int sample_rate, bool flag, char* path);
	void Reset();
	void SetReg(int num, uint8 data);
	void Count(int us);
	void Mix(signed int* buffer, int nsamples);
	uint8 ReadStatus();
	uint8 GetReg(int num);
};

#endif
