/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.08 -

	[ interrupt ]
*/

#ifndef _INTERRUPT_H_
#define _INTERRUPT_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class INTERRUPT : public DEVICE
{
private:
	void do_interrupt();
	
	typedef struct {
		bool request;
		bool running;
		uint8 vector;
	} irq_t;
	irq_t irq[IRQ_MAX];
	
	uint8 irq_mask;

public:
	INTERRUPT(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~INTERRUPT() {}
	
	// common functions
	void initialize();
	void reset();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[3] = { 0xc6, 0xc7, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[2] = { 0xca, -1 };
		return map[index];
	}
	
	void do_reti();
	void do_ei() { do_interrupt(); }
	
	// unique functions
	void request_interrupt(int dev, uint8 vector, bool pending);
	void cancel_interrupt(int dev);
	int interrupt_status(int dev) { return irq[dev].request ? 1 : irq[dev].running ? 2 : 0; }
};

#endif

