/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.05 -

	[ joystick ]
*/

#include "joystick.h"

void JOYSTICK::initialize()
{
	mode = 0xf;
	pulse = 0;
	joy_stat = emu->joy_buffer();
}

void JOYSTICK::write_io8(uint16 addr, uint8 data)
{
	switch(addr & 0xff)
	{
		case 0xef:
			mode = data;
			break;
	}
}

uint8 JOYSTICK::read_io8(uint16 addr)
{
	switch(addr & 0xff)
	{
		case 0xef:
		{
			uint8 state = 0x3f;
			int num = (mode & 0x40) ? 1 : 0;
			bool dir = true;
			
			// trigger mask
			if(num) {
				if(!(mode & 0x04)) state &= 0xdf;
				if(!(mode & 0x08)) state &= 0xef;
				dir = (mode & 0x20) ? false : true;
			}
			else {
				// trigger mask
				if(!(mode & 0x01)) state &= 0xdf;
				if(!(mode & 0x02)) state &= 0xef;
				dir = (mode & 0x10) ? false : true;
			}
			
			// direction
			if(dir) {
				if(joy_stat[num] & 0x8) state &= 0xf7;
				if(joy_stat[num] & 0x4) state &= 0xfb;
				if(joy_stat[num] & 0x2) state &= 0xfd;
				if(joy_stat[num] & 0x1) state &= 0xfe;
			}
			
			// trigger
			if(joy_stat[num] & 0x10) state &= 0xdf;
			if(joy_stat[num] & 0x20) state &= 0xef;
			if(pulse & 2) {
				if(joy_stat[num] & 0x40) state &= 0xdf;
				if(joy_stat[num] & 0x80) state &= 0xef;
			}
			return state;
		}
	}
	return 0xff;
}

void JOYSTICK::update_input()
{
	// synch to vsync
	pulse = (pulse + 1) & 3;
}

