/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.05 -

	[ kanji rom (MZ-1R13) ]
*/

#include "kanji.h"
#include "../fileio.h"

void KANJI::initialize()
{
	// load rom image
	_TCHAR app_path[_MAX_PATH], file_path[_MAX_PATH];
	emu->application_path(app_path);
	_stprintf(file_path, _T("%s%s"), app_path, _T("KANJI2.ROM"));
	
	FILEIO* fio = new FILEIO();
	if(fio->Fopen(file_path, FILEIO_READ_BINARY)) {
		fio->Fread(buf, 0x20000, 1);
		fio->Fclose();
	}
	else
		_memset(buf, 0, 0x20000);
	delete fio;
	
	ptr = 0;
}

void KANJI::write_io8(uint16 addr, uint8 data)
{
	switch(addr & 0xff)
	{
		case 0xb8:
			ptr = (ptr & 0xff00) | data;
			break;
		case 0xb9:
			ptr = (ptr & 0x00ff) | (data << 8);
			break;
	}
}

uint8 KANJI::read_io8(uint16 addr)
{
	switch(addr & 0xff)
	{
		case 0xb8:
			return buf[ptr * 2 + 0];
		case 0xb9:
			return buf[ptr * 2 + 1];
	}
	return 0xff;
}

