/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ rom file ]
*/

#ifndef _ROMFILE_H_
#define _ROMFILE_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class ROMFILE : public DEVICE
{
private:
	uint8* buf;
	uint32 ptr, size;
public:
	ROMFILE(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~ROMFILE() {}
	
	// common functions
	void initialize();
	void release();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[2] = { 0xa8, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[2] = { 0xa9, -1 };
		return map[index];
	}

};

#endif

