/*
	Skelton for Z-80 PC Emulator

	Author : Takeda.Toshiya
	Date   : 2004.04.29 -

	[ screen (win32) ]
*/

#include "emu.h"
#include "vm/vm.h"

void EMU::initialize_screen()
{
	// create dib section
	HDC hdc = GetDC(main_window_handle);
	lpBuf = (LPBYTE)GlobalAlloc(GPTR, sizeof(BITMAPINFO));
	lpDIB = (LPBITMAPINFO)lpBuf;
	lpDIB->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
#ifdef _WIN32_PPC
	// ppc2002 200x320
	lpDIB->bmiHeader.biWidth = 200;
	lpDIB->bmiHeader.biHeight = 320;
#else
	lpDIB->bmiHeader.biWidth = SCREEN_WIDTH;
	lpDIB->bmiHeader.biHeight = SCREEN_HEIGHT;
#endif
	lpDIB->bmiHeader.biPlanes = 1;
	lpDIB->bmiHeader.biBitCount = 16;
#ifdef _WIN32_WCE
	// RGB565
	lpDIB->bmiHeader.biCompression = BI_BITFIELDS;
	LPDWORD lpBf = (LPDWORD)lpDIB->bmiColors;
	lpBf[0] = 0x1f << 11;
	lpBf[1] = 0x3f << 5;
	lpBf[2] = 0x1f << 0;
#else
	lpDIB->bmiHeader.biCompression = BI_RGB;
#endif
	lpDIB->bmiHeader.biSizeImage = 0;
	lpDIB->bmiHeader.biXPelsPerMeter = 0;
	lpDIB->bmiHeader.biYPelsPerMeter = 0;
	lpDIB->bmiHeader.biClrUsed = 0;
	lpDIB->bmiHeader.biClrImportant = 0;
	hBMP = CreateDIBSection(hdc, lpDIB, DIB_RGB_COLORS, (PVOID*)&lpBMP, NULL, 0);
	hdcDIB = CreateCompatibleDC(hdc);
	SelectObject(hdcDIB, hBMP);
}

void EMU::release_screen()
{
	// release dib section
	DeleteDC(hdcDIB);
	DeleteObject(hBMP);
	GlobalFree(lpBuf);
}

void EMU::set_screen_size(int width, int height)
{
#ifdef _WIN32_WCE
	// always fullscreen
	window_width = GetSystemMetrics(SM_CXSCREEN);
	window_height = GetSystemMetrics(SM_CYSCREEN);
#else
	window_width = width;
	window_height = height;
#endif
}

// RGB565
#define MASK_R 0xf800
#define MASK_G 0x07e0
#define MASK_B 0x001f
// RGB555
//#define MASK_R 0x7c00
//#define MASK_G 0x03e0
//#define MASK_B 0x001f

void EMU::draw_screen()
{
	// draw screen if required
	vm->draw_screen();
	
#ifdef _WIN32_PPC
	// compress 640x400 -> 320x200
	for(int y = 0; y < 400; y += 2) {
		for(int x = 0; x < 640; x += 2) {
			uint16 c1 = buffer[y + 0][x + 0];
			uint16 c2 = buffer[y + 0][x + 1];
			uint16 c3 = buffer[y + 1][x + 0];
			uint16 c4 = buffer[y + 1][x + 1];
			uint32 r = (((c1 & MASK_R) + (c2 & MASK_R) + (c3 & MASK_R) + (c4 & MASK_R)) >> 2) & MASK_R;
			uint32 g = (((c1 & MASK_G) + (c2 & MASK_G) + (c3 & MASK_G) + (c4 & MASK_G)) >> 2) & MASK_G;
			uint32 b = (((c1 & MASK_B) + (c2 & MASK_B) + (c3 & MASK_B) + (c4 & MASK_B)) >> 2) & MASK_B;
			lpBMP[200 * (x >> 1) + (y >> 1)] = (uint16)(r | g | b);
		}
	}
#endif
	
	// invalidate window
	InvalidateRect(main_window_handle, NULL, FALSE);
	UpdateWindow(main_window_handle);
}

#define LEFT_MARGINE ((window_width - SCREEN_WIDTH) >> 1)
#define TOP_MARGINE ((window_height - SCREEN_HEIGHT) >> 1)

void EMU::draw_gapi(LPWORD lpDraw)
{
	// draw screen if required
	vm->draw_screen();
	
#ifdef _WIN32_PPC
	// compress 640x400 -> 320x200
	for(int y = 0; y < 400; y += 2) {
		for(int x = 0; x < 640; x += 2) {
			uint16 c1 = buffer[y + 0][x + 0];
			uint16 c2 = buffer[y + 0][x + 1];
			uint16 c3 = buffer[y + 1][x + 0];
			uint16 c4 = buffer[y + 1][x + 1];
			uint32 r = (((c1 & MASK_R) + (c2 & MASK_R) + (c3 & MASK_R) + (c4 & MASK_R)) >> 2) & MASK_R;
			uint32 g = (((c1 & MASK_G) + (c2 & MASK_G) + (c3 & MASK_G) + (c4 & MASK_G)) >> 2) & MASK_G;
			uint32 b = (((c1 & MASK_B) + (c2 & MASK_B) + (c3 & MASK_B) + (c4 & MASK_B)) >> 2) & MASK_B;
			lpBMP[200 * (x >> 1) + (y >> 1)] = (uint16)(r | g | b);
		}
	}
	
	for(int y = 0; y < 320; y++) {
		LPWORD lpDest = lpDraw + 240 * y;
		LPWORD lpSrc = lpBMP + 200 * (320 - y - 1);
		for(int x = 0; x < 200; x++)
			lpDest[x] = lpSrc[x];
	}
#else
	for(int y = 0; y < SCREEN_HEIGHT; y++) {
		LPWORD lpDest = lpDraw + window_width * (y + TOP_MARGINE) + LEFT_MARGINE;
		LPWORD lpSrc = lpBMP + SCREEN_WIDTH * (SCREEN_HEIGHT - y - 1);
		for(int x = 0; x < SCREEN_WIDTH; x++)
			lpDest[x] = lpSrc[x];
	}
#endif
}

void EMU::update_screen(HDC hdc)
{
#ifdef _WIN32_PPC
	BitBlt(hdc, 0, 0, 200, 320, hdcDIB, 0, 0, SRCCOPY);
#else
	BitBlt(hdc, LEFT_MARGINE, TOP_MARGINE, SCREEN_WIDTH, SCREEN_HEIGHT, hdcDIB, 0, 0, SRCCOPY);
#endif
}

