/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.05 -

	[ calendar (RP-5C15) ]
*/

#ifndef _CALENDAR_H_
#define _CALENDAR_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class CALENDAR : public DEVICE
{
private:
	uint8 regs[16];
	uint8 vector;
	int time[8];
	bool irq_done;
	bool signal_1hz;
	bool signal_16hz;
	bool agree;
public:
	CALENDAR(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~CALENDAR() {}
	
	// common functions
	void initialize();
	void reset();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[2] = { 0xcc, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[2] = { 0xcc, -1 };
		return map[index];
	}
	
	void event_callback(int event_id, int err);
	
	// unique functions
	void write_vector(uint8 data) { vector = data; }
	void update_calendar();
};

#endif

