/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ ext rom (MZ-1R12) ]
*/

#include "extrom.h"
#include "../fileio.h"

void EXTROM::initialize()
{
	// load rom image
	_TCHAR app_path[_MAX_PATH], file_path[_MAX_PATH];
	emu->application_path(app_path);
	_stprintf(file_path, _T("%s%s"), app_path, _T("EXT.ROM"));
	
	FILEIO* fio = new FILEIO();
	if(fio->Fopen(file_path, FILEIO_READ_BINARY)) {
		fio->Fread(buf, 0x10000, 1);
		fio->Fclose();
	}
	else
		_memset(buf, 0, 0x10000);
	delete fio;
	
	ptr = 0;
}

void EXTROM::write_io8(uint16 addr, uint8 data)
{
	switch(addr & 0xff)
	{
		case 0xf8:
			// high addr
			ptr = (ptr & 0x00ff) | (data << 8);
			break;
		case 0xf9:
			// low addr
			ptr = (ptr & 0xff00) | data;
			break;
	}
}

uint8 EXTROM::read_io8(uint16 addr)
{
	switch(addr & 0xff)
	{
		case 0xf8:
			// data
			return buf[ptr];
	}
	return 0xff;
}

