/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.05 -

	[ joystick ]
*/

#ifndef _JOYSTICK_H_
#define _JOYSTICK_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class JOYSTICK : public DEVICE
{
private:
	uint8 mode;
	int pulse;
	uint8* joy_stat;
public:
	JOYSTICK(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~JOYSTICK() {}
	
	// common functions
	void initialize();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[2] = { 0xef, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[2] = { 0xef, -1 };
		return map[index];
	}

	// unique function
	void update_input();
};

#endif

