/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.30 -

	[ memory bus ]
*/

#ifndef _MEMORY_H_
#define _MEMORY_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

#define PAGE_TYPE_NORMAL	0
#define PAGE_TYPE_KANJI		1
#define PAGE_TYPE_DIC		2
#define PAGE_TYPE_MODIFY	3

class MEMORY : public DEVICE
{
private:
	uint8* bank_r[32];
	uint8* bank_w[32];
	uint8 dummy_r[0x800];
	uint8 dummy_w[0x800];
	
	uint8 ram[0x40000];	// Main RAM 256KB
	uint8 vram[0x20000];	// VRAM 128KB
	uint8 tvram[0x1800];	// Text VRAM 6KB
	uint8 pcg[0x2000];	// PCG 0-3 8KB
	uint8 ipl[0x8000];	// IPL 32KB
	uint8 dic[0x40000];	// Dictionary ROM 256KB
	uint8 kanji[0x40000];	// Kanji ROM (low) / Kanji ROM (high) 128KB + 128KB
	uint8 phone[0x8000];	// Phone ROM 32KB
	
	uint8 bank;
	uint8 page[8];
	uint8 page_type[8];
	uint8 dic_bank;
	uint8 kanji_bank;
	
	void set_map(uint8 data);

public:
	MEMORY(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~MEMORY() {}
	
	// common functions
	void initialize();
	void reset();
	void ipl_reset();
	
	void write_data8(uint16 addr, uint8 data);
	uint8 read_data8(uint16 addr);
	void write_data16(uint16 addr, uint16 data) { write_data8(addr, data & 0xff); write_data8(addr + 1, data >> 8); }
	uint16 read_data16(uint16 addr) { return read_data8(addr) | (read_data8(addr + 1) << 8); }
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[5] = { 0xb4, 0xb5, 0xce, 0xcf, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[3] = { 0xb4, 0xb5, -1 };
		return map[index];
	}
	
	// unitque function
	uint8* get_vram() { return vram; }
	uint8* get_tvram() { return tvram; }
	uint8* get_kanji() { return kanji; }
	uint8* get_pcg() { return pcg; }
};

#endif

