/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ timer (i8253) ]
*/

#ifndef _TIMER_H_
#define _TIMER_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class TIMER : public DEVICE
{
private:
	typedef struct {
		uint32 count;
		uint16 latch;
		uint8 ctrl_reg;
		uint16 count_reg;
		uint8 mode;
		bool mode0_flag;
		uint8 r_cnt;
		uint8 delay;
		bool start;
	} counter_t;
	counter_t counter[3];
	uint8 vector;
	
	bool update_count(int ch);
	bool fast_timer;
	
public:
	TIMER(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~TIMER() {}
	
	// common functions
	void initialize();
	void update_config();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[9] = { 0xe4, 0xe5, 0xe6, 0xe7, 0xf0, 0xf1, 0xf2, 0xf3, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[4] = { 0xe4, 0xe5, 0xe6, -1 };
		return map[index];
	}
	
	void event_callback(int event_id, int err);
	
	// unique functions
	void write_vector(uint8 data) { vector = data; }
};

#endif

