
#ifndef _CONFIG_H_
#define _CONFIG_H_

#include <tchar.h>

void init_config();
void load_config();
void save_config();

typedef struct {
	int version;	// config file version
	
	// recent files
	_TCHAR recent_disk[4][8][_MAX_PATH];	// drv, history
	_TCHAR recent_tape[8][_MAX_PATH];	// history
	
	// cpu
	int cpu_clock;
	bool m1_cycle;
	
	// timer
	bool fast_timer;
	
	// key, joystick
	int joy_type;
	
	// crtc
	int monitor_type;	// 0=400L,A 1=400L,D 2=200L,A 3=200L,D
	bool scan_line;
	bool super_impose;
	
	// patch
	bool patch_fdc1;
	bool patch_fdc2;
	bool patch_mouse;
	
	// emulation core
	bool sound_enable;
	int sound_frequency;	// 0=11025Hz, 1=22050Hz, 2=44100Hz, 3=48000Hz
	int sound_latency;	// 0=100msec, 1=200msec, 2=300msec, 3=400msec
	int skip_frames;
} config_t;

#endif

