/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ emm ]
*/

#include "emm.h"

void EMM::initialize()
{
	size = 1024 * 1024; //640 * 1024;
	ptr = 0;
	
	buf = (uint8*)malloc(size);
	_memset(buf, 0, size);
}

void EMM::release()
{
	if(buf)
		free(buf);
}

void EMM::write_io8(uint16 addr, uint8 data)
{
	switch(addr & 0xff)
	{
		case 0xac:
			// addr
			ptr = ((addr & 0xff00) << 8) | (data << 8) | (ptr & 0x0000ff);
			break;
		case 0xad:
			// data
			ptr = (ptr & 0xffff00) | (addr >> 8);
			if(ptr < size)
				buf[ptr] = data;
			break;
	}
}

uint8 EMM::read_io8(uint16 addr)
{
	switch(addr & 0xff)
	{
		case 0xad:
			// data
			ptr = (ptr & 0xffff00) | (addr >> 8);
			return (ptr < size) ? buf[ptr] : 0xff;
	}
	return 0xff;
}

