/*
	MZ-2500 Emulator 'EmuZ-2500'

	Author : Takeda.Toshiya
	Date   : 2003.11.28 -

	[ FM ]
*/

#include "opn.h"

#define SSG_VOL 4500.0
#define OPN_VOL 5500.0

void OPN::Init(int clock, int sample_rate, bool flag, char* path)
{
	rate = sample_rate;
}

void OPN::Reset()
{
	_memset(f_number, 0, sizeof(f_number));
	_memset(volume, 0, sizeof(volume));
	_memset(octove, 0, sizeof(octove));
	_memset(frq, 0, sizeof(frq));
	_memset(interval, 0, sizeof(interval));
	_memset(counter, 0, sizeof(counter));
	_memset(pulse, 0, sizeof(pulse));
	keyon[0] = keyon[1] = keyon[2] = TRUE;
	keyon[3] = keyon[4] = keyon[5] = TRUE;
	ssg_pre = 4;
	opn_pre = 6;
}

void OPN::SetReg(int num, uint8 data)
{
	int ch = num & 0x3;
	
	if(num == 0x00) {
		f_number[0] &= 0xf00;
		f_number[0] |= data;
		frq[0] = 250000.0 / ssg_pre / (double)(f_number[0] + 1);
		interval[0] = rate / frq[0] / 2.0;
	}
	else if(num == 0x01) {
		f_number[0] &= 0x0ff;
		f_number[0] |= data << 8;
		frq[0] = 250000.0 / ssg_pre / (double)(f_number[0] + 1);
		interval[0] = rate / frq[0] / 2.0;
	}
	else if(num == 0x02) {
		f_number[1] &= 0xf00;
		f_number[1] |= data;
		frq[1] = 250000.0 / ssg_pre / (double)(f_number[1] + 1);
		interval[1] = rate / frq[1] / 2.0;
	}
	else if(num == 0x03) {
		f_number[1] &= 0x0ff;
		f_number[1] |= data << 8;
		frq[1] = 250000.0 / ssg_pre / (double)(f_number[1] + 1);
		interval[1] = rate / frq[1] / 2.0;
	}
	else if(num == 0x04) {
		f_number[2] &= 0xf00;
		f_number[2] |= data;
		frq[2] = 250000.0 / ssg_pre / (double)(f_number[2] + 1);
		interval[2] = rate / frq[2] / 2.0;
	}
	else if(num == 0x05) {
		f_number[2] &= 0x0ff;
		f_number[2] |= data << 8;
		frq[2] = 250000.0 / ssg_pre / (double)(f_number[2] + 1);
		interval[2] = rate / frq[2] / 2.0;
	}
	else if(num == 0x28) {
		if((data & 0x3) != 3)
			keyon[(data & 0x3) + 3] = (data & 0x80) ? TRUE : FALSE;
	}
	else if(0x08 <= num && num <= 0x0a) {
		// ssg volume
		volume[ch] = (WORD)(SSG_VOL / 15.0 * (data & 0xf));
	}
	else if(num == 0x28) {
		keyon[0] = (data & 0x1) ? FALSE : TRUE;
		keyon[1] = (data & 0x2) ? FALSE : TRUE;
		keyon[2] = (data & 0x4) ? FALSE : TRUE;
	}
	else if(num == 0x2d) {
		ssg_pre = 4;
		opn_pre = 6;
	}
	else if(num == 0x2e) {
		ssg_pre = 3;
		opn_pre = 2;
	}
	else if(num == 0x2f) {
		ssg_pre = 1;
		opn_pre = 2;
	}
	else if(0x4c <= num && num <= 0x4e) {
		// opn volume
		double db = 0, vol = OPN_VOL;
		db += (data & 0x40) ? 48.0  : 0.0;
		db += (data & 0x20) ? 24.0  : 0.0;
		db += (data & 0x10) ? 12.0  : 0.0;
		db += (data & 0x08) ?  6.0  : 0.0;
		db += (data & 0x04) ?  3.0  : 0.0;
		db += (data & 0x02) ?  1.5  : 0.0;
		db += (data & 0x01) ?  0.75 : 0.0;
		int cnt = (int)(db / 3.01 + 0.5);
		for(int i = 0; i < cnt; i++)
			vol /= 2.0;
		volume[ch + 3] = (WORD)vol;
	}
	else if(0xa0 <= num && num <= 0xa2) {
		// opn f-number
		f_number[ch + 3] &= 0x700;
		f_number[ch + 3] |= data;
		frq[ch + 3] = 2000000.0 / 1572864.0 / opn_pre * (double)f_number[ch + 3];
		if(octove[ch + 3] < 4) {
			for(int i = 0; i < 4 - octove[ch + 3]; i++)
				frq[ch + 3] /= 2.0;
		}
		else {
			for(int i = 0; i < octove[ch + 3] - 4; i++)
				frq[ch + 3] *= 2.0;
		}
		interval[ch + 3] = rate / (frq[ch + 3] + 1) / 2;
	}
	else if(0xa4 <= num && num <= 0xa6) {
		// opn f-number
		octove[ch + 3] = (data >> 3) & 0x7;
		f_number[ch + 3] = (data & 0x7) << 8;
	}
	if(num < 0x10)
		regs[num] = data;
}

void OPN::Count(int us)
{
	
}

void OPN::Mix(signed int* buffer, int nsamples)
{
	for(int i = 0; i < nsamples; i++) {
		int vol = 0;
		for(int j = 0; j < 6; j++) {
			if(keyon[j]) {
				counter[j] += 1;
				if(counter[j] >= interval[j]) {
					pulse[j] = !pulse[j];
					counter[j] -= interval[j];
				}
				if(pulse[j])
					vol += volume[j];
				else
					vol -= volume[j];
			}
		}
		buffer[i] = vol;
	}
}

uint8 OPN::ReadStatus()
{
	return 0;
}

uint8 OPN::GetReg(int num)
{
	return (num < 0x10) ? regs[num] : 0;
}

