/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.08 -

	[ interrupt ]
*/

#include "interrupt.h"
#include "z80.h"
#include "calendar.h"
#include "crtc.h"
//#include "printer.h"
#include "timer.h"

void INTERRUPT::initialize()
{
	for(int i = 0; i < IRQ_MAX; i++) {
		irq[i].request = false;
		irq[i].running = false;
	}
	irq_mask = 0;
}

void INTERRUPT::reset()
{
	for(int i = 0; i < IRQ_MAX; i++) {
		irq[i].request = false;
		irq[i].running = false;
	}
	irq_mask = 0;
}

void INTERRUPT::write_io8(uint16 addr, uint8 data)
{
	switch(addr & 0xff)
	{
		case 0xc6:
			irq_mask = data;
			break;
		case 0xc7:
			if(irq_mask & 0x80)
				vm->crtc->write_vector(data);
			if(irq_mask & 0x40)
				vm->timer->write_vector(data);
//			if(irq_mask & 0x20)
//				vm->printer->write_vector(data);
			if(irq_mask & 0x10)
				vm->calendar->write_vector(data);
			break;
	}
}

uint8 INTERRUPT::read_io8(uint16 addr)
{
	switch(addr & 0xff)
	{
		case 0xca:
			return 0x30; // ?
	}
	return 0xff;
}

void INTERRUPT::request_interrupt(int dev, uint8 vector, bool pending)
{
	// accept the request when an interrupt requested by its device is not running now
	if(!irq[dev].running) {
		irq[dev].request = true;
		irq[dev].vector = vector;
		do_interrupt();
	}
	
	// cancel request when not pending
	if(!pending)
		irq[dev].request = false;
}

void INTERRUPT::cancel_interrupt(int dev)
{
	irq[dev].request = false;
}

void INTERRUPT::do_reti()
{
	// most high priority request is finished
	for(int i = 0; i < IRQ_MAX; i++) {
		if(irq[i].running) {
			irq[i].running = false;
			// try next interrupt
			do_interrupt();
			return;
		}
	}
}

void INTERRUPT::do_interrupt()
{
	// check cpu status
	if(!vm->cpu->accept_int())
		return;
	
	// try interrupt when cpu can accept interrupt requst
	for(int i = 0; i < IRQ_MAX; i++) {
		// quit when more high priority request is running
		if(irq[i].running)
			return;
		
		// check irq mask
		if(!(irq_mask & 0x8) && i == IRQ_VBLANK) continue;
		if(!(irq_mask & 0x4) && i == IRQ_TIMER) continue;
		if(!(irq_mask & 0x2) && i == IRQ_PRINTER) continue;
		if(!(irq_mask & 0x1) && i == IRQ_CALENDAR) continue;
		
		// do interrupt
		if(irq[i].request) {
			irq[i].running = true;
			irq[i].request = false;
			vm->cpu->do_int(irq[i].vector);
			return;
		}
	}
}

