/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.05 -

	[ kanji rom (MZ-1R13) ]
*/

#ifndef _KANJI_H_
#define _KANJI_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class KANJI : public DEVICE
{
private:
	uint8 buf[0x20000];
	uint16 ptr;
public:
	KANJI(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~KANJI() {}
	
	// common functions
	void initialize();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[3] = { 0xb8, 0xb9, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[3] = { 0xb8, 0xb9, -1 };
		return map[index];
	}
};

#endif

