/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.30 -

	[ keyboard (Z-80PIO) ]
*/

#ifndef _KEYBOARD_H_
#define _KEYBOARD_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

#define UPDATE_PER_SEC	55.4

static const int key_map[14][8] = {
	{0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77},
	{0x78, 0x79, 0x68, 0x69, 0x6c, 0x6e, 0x6b, 0x6d},
	{0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67},
	{0x09, 0x20, 0x0d, 0x26, 0x28, 0x25, 0x27, 0x13},
	{0xbf, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47},
	{0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f},
	{0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57},
	{0x58, 0x59, 0x5a, 0xde, 0xdc, 0xe2, 0xbe, 0xbc},
	{0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37},
	{0x38, 0x39, 0xba, 0xbb, 0xbd, 0xc0, 0xdb, 0x00},
	{0xdd, 0x7b, 0x24, 0x2e, 0x08, 0x1b, 0x6a, 0x6f},
	{0x12, 0x14, 0x10, 0x15, 0x11, 0x00, 0x00, 0x00},
	{0x1d, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x19, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
};

class KEYBOARD : public DEVICE
{
private:
	// Z-80 PIO
	typedef struct {
		uint8 reg;
		uint8 mode;
		uint8 ctrl;
		uint8 dir;
		uint8 mask;
		uint8 vector;
		bool set_dir;
		bool set_mask;
		bool prv_req;
	} port_t;
	port_t port[2];
	
	// keyboard
	uint8* key_stat;
	void create_keystat();
	void check_interrupt(int p);
	uint8 keys[16];

public:
	KEYBOARD(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~KEYBOARD() {}
	
	// common functions
	void initialize();
	void reset();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[5] = { 0xe8, 0xe9, 0xea, 0xeb, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[3] = { 0xe8, 0xea, -1 };
		return map[index];
	}
	
	// unique function
	void update_input();
};

#endif

