/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.09.05 -

	[ mouse ]
*/

#ifndef _MOUSE_H_
#define _MOUSE_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class MOUSE : public DEVICE
{
private:
	// mouse
	int* mouse_stat;
	bool mouse_select;
	
	// sio
	uint8 rega[8], regb[8];
	int rega_num, regb_num;
	bool nextrecv_irq;
	bool over_flow;
	
	uint8 port_select;
	
	// fifo
	bool push(uint8 data);
	uint8 pop();
	uint8 fifo[8];
	int fifo_w, fifo_r;
	
	// event
	int regist_id[3];
	uint8 recv_data[3];
public:
	MOUSE(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~MOUSE() {}
	
	// common functions
	void initialize();
	void reset();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[6] = { 0xa1, 0xa3, 0xb1, 0xb3, 0xcd, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[9] = { 0xa0, 0xa1, 0xa2, 0xa3, 0xb0, 0xb1, 0xb2, 0xb3, -1 };
		return map[index];
	}
	
	void write_signal(int ch, uint32 data);
	void event_callback(int event_id, int err);
};

#endif

