/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.30 -

	[ sound (YM2203) ]
*/

#ifndef _SOUND_H_
#define _SOUND_H_

#include "vm.h"
#include "../emu.h"
#include "fmgen/opna.h"
//#include "fmce/opn.h"

#include "device.h"

#define SOUND_CLOCK 2000000
#define PCM_SAMPLES 24376
#define PCM_VOLUME 0x1000

class SOUND : public DEVICE
{
private:
	// config
	bool sound_enable;
	bool monitor_200line;
	
	// fmgen
	FM::OPN* opn;
	//OPN* opn;
	uint8 reg_num;
	int frame_usec;
	
	// calendar, pcm
	bool alarm_signal;
	bool pcm_buffer[PCM_SAMPLES];
	bool pcm_signal;
	int pcm_ptr;
	
	// sound buffer
	int32* sound_tmp;
	uint16* sound_buffer;
	int buffer_ptr;
	int accum_cnt, frame_cnt;
	int sound_rate, sound_samples;
	
	// recovery
	uint8 regs[256];
	uint8 reg_28h[4];
	uint8 reg_a0h[8], reg_a1h[8], reg_a2h[8];
	uint8 reg_a4h[8], reg_a5h[8], reg_a6h[8];
	uint8 reg_a8h[8], reg_a9h[8], reg_aah[8];
	uint8 reg_ach[8], reg_adh[8], reg_aeh[8];
	
public:
	SOUND(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~SOUND() {}
	
	// common functions
	void initialize();
	void release();
	void update_config();
	void reset();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[3] = { 0xc8, 0xc9, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[3] = { 0xc8, 0xc9, -1 };
		return map[index];
	}
	
	void write_signal(int ch, uint32 data);
	
	// unique function
	void initialize_sound(int rate, int samples);
	void update_sound();
	uint16* create_sound(int samples, bool fill);
};

#endif

