/*
	SHARP MZ-2500 Emulator 'EmuZ-2500'
	(Skelton for Z-80 PC Emulator)

	Author : Takeda.Toshiya
	Date   : 2004.08.31 -

	[ timer (i8253) ]
*/

#ifndef _TIMER_H_
#define _TIMER_H_

#include "vm.h"
#include "../emu.h"

#include "device.h"

class COUNTER
{
private:
	uint16 count_reg, count_latch;
	uint32 count;
	int mode, rl10, delay, readcnt;
	bool start, bcd, latch, mode0;
	
	void reg_to_count();
	void count_to_latch();
public:
	COUNTER();
	~COUNTER() {}
	
	void write_ctrl(uint8 data);
	void write_count(uint8 data);
	uint8 read_count();
	void write_gate();
	bool write_clock();
};

class TIMER : public DEVICE
{
private:
	COUNTER* counter[3];
	uint8 vector;
	
public:
	TIMER(VM* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu) {}
	~TIMER() {}
	
	// common functions
	void initialize();
	void release();
	
	void write_io8(uint16 addr, uint8 data);
	uint8 read_io8(uint16 addr);
	
	int iomap_write(int index) {
		static const int map[9] = { 0xe4, 0xe5, 0xe6, 0xe7, 0xf0, 0xf1, 0xf2, 0xf3, -1 };
		return map[index];
	}
	int iomap_read(int index) {
		static const int map[4] = { 0xe4, 0xe5, 0xe6, -1 };
		return map[index];
	}
	
	void event_callback(int event_id, int err);
	
	// unique functions
	void write_vector(uint8 data) { vector = data; }
};

#endif

