/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import net.espley.microprocessor.Z80;
import net.espley.processor.Utility;

public class ExecuteZ80
implements Runnable {
    public static final int SINGLE_STEP = 1;
    public static final int FOREVER = 2;
    public static final int ADDRESS = 3;
    private Z80 z80;
    private int mode = 0;
    private int address;
    private int NMICounter = 0;
    private boolean run;
    private boolean running = false;

    public void run() {
        this.running = true;
        long t1 = System.currentTimeMillis();
        Utility utility = new Utility();
        try {
            switch (this.mode) {
                case 1: {
                    this.processNascomNMI();
                    this.z80.execute();
                    break;
                }
                case 2: {
                    while (this.run) {
                        this.processNascomNMI();
                        this.z80.execute();
                    }
                    break;
                }
                case 3: {
                    while (this.z80.getProgramCounter() != this.address & this.run) {
                        this.processNascomNMI();
                        this.z80.execute();
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.running = false;
            long t2 = System.currentTimeMillis();
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Execution time : ").append((t2 - t1) / (long)1000).append(" seconds"))));
            e.printStackTrace();
        }
        this.running = false;
    }

    public void requestSingleStepNMI() {
        this.NMICounter = 4;
    }

    private void processNascomNMI() {
        if (this.NMICounter != 0) {
            --this.NMICounter;
            if (this.NMICounter == 0) {
                this.z80.setNMI();
            }
        }
    }

    public void setProcessor(Z80 z80, int mode, int address) {
        this.z80 = z80;
        this.mode = mode;
        this.address = address;
    }

    public void setRun(boolean run) {
        this.run = run;
        if (!run) {
            while (this.running) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        SINGLE_STEP = 1;
        FOREVER = 2;
        ADDRESS = 3;
    }
}

