/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import net.espley.microprocessor.IBaseDevice;
import net.espley.processor.PropertyStatus;

class IOPorts
implements IBaseDevice {
    final int memorySize = 256;
    final int byteSize = 8;
    final int maxAddress = 255;
    private ArrayList IORead = new ArrayList(5);
    private ArrayList IOWrite = new ArrayList(5);
    private int[] io = new int[256];

    IOPorts() {
        this.reset();
    }

    public boolean supportsIOReads() {
        return true;
    }

    public boolean supportsIOWrites() {
        return true;
    }

    public int IORead(int address) {
        Iterator item = ((AbstractList)this.IORead).iterator();
        while (item.hasNext()) {
            ((IBaseDevice)item.next()).IORead(address);
        }
        return this.io[address];
    }

    public void setReadStatus(int address, boolean readOnly) {
    }

    public void IOWrite(int address, int data) {
        this.io[address] = data;
        Iterator item = ((AbstractList)this.IOWrite).iterator();
        while (item.hasNext()) {
            ((IBaseDevice)item.next()).IOWrite(address, data);
        }
    }

    public void writeByteDirect(int address, int data) {
        this.io[address] = data;
    }

    public void reset() {
        for (int i = 0; i < 256; ++i) {
            this.io[i] = 0;
        }
        this.IORead = new ArrayList();
        this.IOWrite = new ArrayList();
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("IO space reset");
        }
    }

    public void addDevice(IBaseDevice newDevice) {
        if (newDevice.supportsIOReads()) {
            this.IORead.add(newDevice);
        }
        if (newDevice.supportsIOWrites()) {
            this.IOWrite.add(newDevice);
        }
    }
}

