/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.espley.microprocessor.IBaseDevice;
import net.espley.processor.IOPorts;

public class Uart
implements IBaseDevice {
    private static IOPorts io;
    private boolean tapeOn = false;
    private boolean readMode = false;
    private boolean writeMode = false;
    File readFile;
    File writeFile;
    FileInputStream inputStream;
    FileOutputStream outputStream;
    private int lastByteRead;

    Uart(IOPorts io) {
        try {
            this.readFile = new File("read.cas");
            this.inputStream = new FileInputStream(this.readFile);
            this.writeFile = new File("write.cas");
            this.outputStream = new FileOutputStream(this.writeFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Uart.io = io;
        this.reset();
    }

    protected void finalize() {
        System.out.println("Closing write.cas file");
        try {
            this.outputStream.close();
            this.inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean supportsMemoryReads() {
        return false;
    }

    public boolean supportsMemoryWrites() {
        return false;
    }

    public boolean supportsIOReads() {
        return true;
    }

    public boolean supportsIOWrites() {
        return true;
    }

    public int memoryRead(int address) {
        return 0;
    }

    public void memoryWrite(int address, int data) {
    }

    public int IORead(int address) {
        if (address == 1) {
            try {
                if (this.tapeOn) {
                    this.lastByteRead = this.inputStream.read();
                    io.writeByteDirect(1, this.lastByteRead);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (address == 2) {
            int controlByte = 64;
            try {
                if (this.inputStream.available() > 0 && this.tapeOn) {
                    controlByte |= 0x80;
                }
                io.writeByteDirect(2, controlByte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void IOWrite(int address, int data) {
        block6: {
            block5: {
                if (address != 0) break block5;
                if ((data & 0x10) != 0) {
                    this.tapeOn = true;
                } else {
                    this.tapeOn = false;
                    this.readMode = false;
                    this.writeMode = false;
                }
                break block6;
            }
            if (address != 1 || !this.tapeOn) break block6;
            if (!this.writeMode) {
                this.writeMode = true;
            }
            try {
                this.outputStream.write(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reset() {
    }
}

